/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.audit.pageprovider;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.comment.CommentProcessorHelper;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.elasticsearch.audit.ESAuditBackend;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class ESAuditPageProvider
extends AbstractPageProvider<LogEntry>
implements PageProvider<LogEntry> {
    private static final long serialVersionUID = 1L;
    protected SearchRequest searchRequest;
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String UICOMMENTS_PROPERTY = "generateUIComments";
    protected static String emptyQuery = "{ \"match_all\" : { }\n }";
    protected Long maxResultWindow;

    public String toString() {
        this.buildAuditQuery(true);
        return this.searchRequest.toString();
    }

    protected CoreSession getCoreSession() {
        Object session = this.getProperties().get(CORE_SESSION_PROPERTY);
        if (session != null && session instanceof CoreSession) {
            return (CoreSession)session;
        }
        return null;
    }

    protected void preprocessCommentsIfNeeded(List<LogEntry> entries) {
        CoreSession session;
        Serializable preprocess = (Serializable)this.getProperties().get(UICOMMENTS_PROPERTY);
        if (preprocess != null && "true".equalsIgnoreCase(preprocess.toString()) && (session = this.getCoreSession()) != null) {
            CommentProcessorHelper cph = new CommentProcessorHelper(session);
            cph.processComments(entries);
        }
    }

    public List<LogEntry> getCurrentPage() {
        this.buildAuditQuery(true);
        this.searchRequest.source().from((int)(this.getCurrentPageIndex() * this.pageSize));
        this.searchRequest.source().size((int)this.getMinMaxPageSize());
        for (SortInfo sortInfo : this.getSortInfos()) {
            this.searchRequest.source().sort(sortInfo.getSortColumn(), sortInfo.getSortAscending() ? SortOrder.ASC : SortOrder.DESC);
        }
        SearchResponse searchResponse = this.getESBackend().search(this.searchRequest);
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        SearchHits hits = searchResponse.getHits();
        this.setResultsCount(hits.getTotalHits());
        ObjectMapper mapper = new ObjectMapper();
        for (SearchHit hit : hits) {
            try {
                entries.add((LogEntry)mapper.readValue(hit.getSourceAsString(), LogEntryImpl.class));
            }
            catch (IOException e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        this.preprocessCommentsIfNeeded(entries);
        long t0 = System.currentTimeMillis();
        CoreSession session = this.getCoreSession();
        if (session != null) {
            this.fireSearchEvent(session.getPrincipal(), this.searchRequest.toString(), entries, System.currentTimeMillis() - t0);
        }
        return entries;
    }

    protected boolean isNonNullParam(Object[] val) {
        if (val == null) {
            return false;
        }
        for (Object v : val) {
            if (v == null) continue;
            if (v instanceof String) {
                if (((String)v).isEmpty()) continue;
                return true;
            }
            if (v instanceof String[]) {
                if (((String[])v).length <= 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    protected String getFixedPart() {
        if (this.getDefinition().getWhereClause() == null) {
            return null;
        }
        String fixedPart = this.getDefinition().getWhereClause().getFixedPart();
        if (fixedPart == null || fixedPart.isEmpty()) {
            fixedPart = emptyQuery;
        }
        return fixedPart;
    }

    protected boolean allowSimplePattern() {
        return true;
    }

    protected ESAuditBackend getESBackend() {
        NXAuditEventsService audit = (NXAuditEventsService)Framework.getRuntime().getComponent(NXAuditEventsService.NAME);
        AuditBackend backend = audit.getBackend();
        if (backend instanceof ESAuditBackend) {
            return (ESAuditBackend)backend;
        }
        throw new NuxeoException("Unable to use ESAuditPageProvider if audit service is not configured to run with ElasticSearch");
    }

    protected void buildAuditQuery(boolean includeSort) {
        WhereClauseDefinition whereClause;
        PageProviderDefinition def = this.getDefinition();
        Object[] params = this.getParameters();
        List quickFilters = this.getQuickFilters();
        String quickFiltersClause = "";
        if (quickFilters != null && !quickFilters.isEmpty()) {
            for (QuickFilter quickFilter : quickFilters) {
                String clause = quickFilter.getClause();
                if (!quickFiltersClause.isEmpty() && clause != null) {
                    quickFiltersClause = NXQLQueryBuilder.appendClause((String)quickFiltersClause, (String)clause);
                    continue;
                }
                quickFiltersClause = clause != null ? clause : "";
            }
        }
        if ((whereClause = def.getWhereClause()) == null) {
            if (!this.allowSimplePattern()) {
                throw new UnsupportedOperationException("This page provider requires a explicit Where Clause");
            }
            String originalPattern = def.getPattern();
            String pattern = quickFiltersClause.isEmpty() ? originalPattern : (StringUtils.containsIgnoreCase((CharSequence)originalPattern, (CharSequence)" WHERE ") ? NXQLQueryBuilder.appendClause((String)originalPattern, (String)quickFiltersClause) : originalPattern + " WHERE " + quickFiltersClause);
            String baseQuery = this.getESBackend().expandQueryVariables(pattern, params);
            this.searchRequest = this.getESBackend().buildQuery(baseQuery, null);
        } else {
            String fixedPart = this.getFixedPart();
            if (!StringUtils.isBlank((CharSequence)quickFiltersClause)) {
                fixedPart = !StringUtils.isBlank((CharSequence)fixedPart) ? NXQLQueryBuilder.appendClause((String)fixedPart, (String)quickFiltersClause) : quickFiltersClause;
            }
            String baseQuery = this.getESBackend().expandQueryVariables(fixedPart, params);
            this.searchRequest = this.getESBackend().buildSearchQuery(baseQuery, whereClause.getPredicates(), this.getSearchDocumentModel());
        }
    }

    public void refresh() {
        this.setCurrentPageOffset(0L);
        super.refresh();
    }

    public long getResultsCount() {
        return this.resultsCount;
    }

    public List<SortInfo> getSortInfos() {
        List sortInfos = super.getSortInfos();
        for (SortInfo si : sortInfos) {
            if (!si.getSortColumn().startsWith("log.")) continue;
            si.setSortColumn(si.getSortColumn().substring(4));
        }
        return sortInfos;
    }

    public boolean isLastPageAvailable() {
        if (this.getResultsCount() + this.getPageSize() <= this.getMaxResultWindow()) {
            return super.isNextPageAvailable();
        }
        return false;
    }

    public boolean isNextPageAvailable() {
        if (this.getCurrentPageOffset() + 2L * this.getPageSize() <= this.getMaxResultWindow()) {
            return super.isNextPageAvailable();
        }
        return false;
    }

    public long getPageLimit() {
        return this.getMaxResultWindow() / this.getPageSize();
    }

    public long getMaxResultWindow() {
        if (this.maxResultWindow == null) {
            ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
            String maxResultWindowStr = cs.getProperty("org.nuxeo.elasticsearch.provider.maxResultWindow", "10000");
            try {
                this.maxResultWindow = Long.valueOf(maxResultWindowStr);
            }
            catch (NumberFormatException e) {
                log.warn((Object)String.format("Invalid maxResultWindow property value: %s for page provider: %s, fallback to default.", maxResultWindowStr, this.getName()));
                this.maxResultWindow = Long.valueOf("10000");
            }
        }
        return this.maxResultWindow;
    }

    public void setMaxResultWindow(long maxResultWindow) {
        this.maxResultWindow = maxResultWindow;
    }
}

