/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.audit;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.WrapperQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.max.Max;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.query.sql.model.Literals;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorService;
import org.nuxeo.ecm.core.uidgen.UIDSequencer;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.audit.api.AuditQueryBuilder;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.audit.service.AbstractAuditBackend;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.BaseLogEntryProvider;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.ecm.platform.query.api.PredicateDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.audit.ESAuditMigrationWork;
import org.nuxeo.elasticsearch.audit.ESExtendedInfo;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class ESAuditBackend
extends AbstractAuditBackend
implements AuditBackend {
    public static final String SEQ_NAME = "audit";
    public static final String MIGRATION_FLAG_PROP = "audit.elasticsearch.migration";
    public static final String MIGRATION_BATCH_SIZE_PROP = "audit.elasticsearch.migration.batchSize";
    public static final String MIGRATION_DONE_EVENT = "sqlToElasticsearchMigrationDone";
    public static final int MIGRATION_DEFAULT_BACTH_SIZE = 1000;
    protected ESClient esClient;
    protected static final Log log = LogFactory.getLog(ESAuditBackend.class);
    protected BaseLogEntryProvider provider = new BaseLogEntryProvider(){

        public int removeEntries(String eventId, String pathPattern) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public void addLogEntry(LogEntry logEntry) {
            ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
            entries.add(logEntry);
            ESAuditBackend.this.addLogEntries(entries);
        }
    };

    public ESAuditBackend(NXAuditEventsService component, AuditBackendDescriptor config) {
        super(component, config);
    }

    public ESAuditBackend() {
    }

    protected ESClient getClient() {
        log.info((Object)"Activate Elasticsearch backend for Audit");
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        ESClient client = esa.getClient();
        this.ensureUIDSequencer(client);
        return client;
    }

    protected boolean isMigrationDone() {
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        List entries = reader.queryLogs(new String[]{MIGRATION_DONE_EVENT}, null);
        return !entries.isEmpty();
    }

    public int getApplicationStartedOrder() {
        int elasticOrder = ((DefaultComponent)Framework.getRuntime().getComponent("org.nuxeo.elasticsearch.ElasticSearchComponent")).getApplicationStartedOrder();
        int uidgenOrder = ((DefaultComponent)Framework.getRuntime().getComponent("org.nuxeo.ecm.core.uidgen.UIDGeneratorService")).getApplicationStartedOrder();
        return Integer.max(elasticOrder, uidgenOrder) + 1;
    }

    public void onApplicationStarted() {
        this.esClient = this.getClient();
        if (Boolean.parseBoolean(Framework.getProperty((String)MIGRATION_FLAG_PROP))) {
            if (!this.isMigrationDone()) {
                log.info((Object)String.format("Property %s is true and migration is not done yet, processing audit migration from SQL to Elasticsearch index", MIGRATION_FLAG_PROP));
                ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
                esa.dropAndInitIndex(this.getESIndexName());
                int batchSize = 1000;
                String batchSizeProp = Framework.getProperty((String)MIGRATION_BATCH_SIZE_PROP);
                if (batchSizeProp != null) {
                    batchSize = Integer.parseInt(batchSizeProp);
                }
                this.migrate(batchSize);
            } else {
                log.warn((Object)String.format("Property %s is true but migration is already done, please set this property to false", MIGRATION_FLAG_PROP));
            }
        } else {
            log.debug((Object)String.format("Property %s is false, not processing any migration", MIGRATION_FLAG_PROP));
        }
    }

    public void onApplicationStopped() {
        if (this.esClient == null) {
            return;
        }
        try {
            this.esClient.close();
        }
        catch (Exception e) {
            log.warn((Object)("Fail to close esClient: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.esClient = null;
        }
    }

    public List<LogEntry> queryLogs(AuditQueryBuilder builder) {
        List<LogEntry> logEntries;
        Predicate andPredicate = builder.predicate();
        OrderByList orders = builder.orders();
        long offset = builder.offset();
        long limit = builder.limit();
        List predicates = ((MultiExpression)andPredicate).values;
        QueryBuilder query = this.createQueryBuilder(predicates);
        SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)query)).size(100);
        orders.forEach(order -> source.sort(order.reference.name, order.isDescending ? SortOrder.DESC : SortOrder.ASC));
        SearchRequest request = this.createSearchRequest();
        request.source(source);
        if (limit == 0L) {
            TimeValue keepAlive = TimeValue.timeValueMinutes((long)1L);
            request.scroll(keepAlive);
            source.size(100);
            this.logSearchRequest(request);
            SearchResponse searchResponse = this.esClient.search(request);
            this.logSearchResponse(searchResponse);
            logEntries = this.buildLogEntries(searchResponse);
            while (searchResponse.getHits().getHits().length > 0 && (long)logEntries.size() < searchResponse.getHits().getTotalHits()) {
                logEntries.addAll(this.buildLogEntries(searchResponse));
                searchResponse = this.runNextScroll(searchResponse.getScrollId(), keepAlive);
            }
        } else {
            source.from((int)offset).size((int)limit);
            this.logSearchRequest(request);
            SearchResponse searchResponse = this.esClient.search(request);
            this.logSearchResponse(searchResponse);
            logEntries = this.buildLogEntries(searchResponse);
        }
        return logEntries;
    }

    protected QueryBuilder createQueryBuilder(List<Predicate> predicates) {
        MatchAllQueryBuilder query;
        Function<Operand, String> getFieldName = operand -> ((Reference)operand).name;
        if (predicates.isEmpty()) {
            query = QueryBuilders.matchAllQuery();
        } else {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            for (Predicate predicate : predicates) {
                String leftName = getFieldName.apply(predicate.lvalue);
                Operator operator = predicate.operator;
                Object rightValue = Literals.valueOf((Operand)predicate.rvalue);
                if (Operator.EQ.equals((Object)operator)) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)leftName, (Object)rightValue));
                    continue;
                }
                if (Operator.NOTEQ.equals((Object)operator)) {
                    boolQuery.mustNot((QueryBuilder)QueryBuilders.termQuery((String)leftName, (Object)rightValue));
                    continue;
                }
                if (Operator.LT.equals((Object)operator)) {
                    boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)leftName).lt(rightValue));
                    continue;
                }
                if (Operator.LTEQ.equals((Object)operator)) {
                    boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)leftName).lte(rightValue));
                    continue;
                }
                if (Operator.GTEQ.equals((Object)operator)) {
                    boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)leftName).gte(rightValue));
                    continue;
                }
                if (Operator.GT.equals((Object)operator)) {
                    boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)leftName).gt(rightValue));
                    continue;
                }
                if (!Operator.IN.equals((Object)operator)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)leftName, (Collection)((List)rightValue)));
            }
            query = boolQuery;
        }
        return query;
    }

    SearchResponse runNextScroll(String scrollId, TimeValue keepAlive) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Scroll request: -XGET 'localhost:9200/_search/scroll' -d '{\"scroll\": \"%s\", \"scroll_id\": \"%s\" }'", keepAlive, scrollId));
        }
        SearchResponse response = this.esClient.searchScroll(new SearchScrollRequest(scrollId).scroll(keepAlive));
        this.logSearchResponse(response);
        return response;
    }

    protected List<LogEntry> buildLogEntries(SearchResponse searchResponse) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>(searchResponse.getHits().getHits().length);
        ObjectMapper mapper = new ObjectMapper();
        for (SearchHit hit : searchResponse.getHits()) {
            try {
                entries.add((LogEntry)mapper.readValue(hit.getSourceAsString(), LogEntryImpl.class));
            }
            catch (IOException e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        return entries;
    }

    protected SearchRequest createSearchRequest() {
        return new SearchRequest(new String[]{this.getESIndexName()}).types(new String[]{"entry"}).searchType(SearchType.DFS_QUERY_THEN_FETCH);
    }

    public LogEntry getLogEntryByID(long id) {
        GetResponse ret = this.esClient.get(new GetRequest(this.getESIndexName(), "entry", String.valueOf(id)));
        if (!ret.isExists()) {
            return null;
        }
        try {
            return (LogEntry)new ObjectMapper().readValue(ret.getSourceAsString(), LogEntryImpl.class);
        }
        catch (IOException e) {
            throw new NuxeoException("Unable to read Entry for id " + id, (Throwable)e);
        }
    }

    public SearchRequest buildQuery(String query, Map<String, Object> params) {
        if (params != null && params.size() > 0) {
            query = this.expandQueryVariables(query, params);
        }
        SearchRequest request = this.createSearchRequest();
        SearchSourceBuilder sourceBuilder = this.createSearchSourceBuilder(query);
        return request.source(sourceBuilder);
    }

    protected SearchSourceBuilder createSearchSourceBuilder(String query) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        SearchModule searchModule = new SearchModule(Settings.EMPTY, false, Collections.emptyList());
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(new NamedXContentRegistry(searchModule.getNamedXContents()), query);){
            searchSourceBuilder.parseXContent(new QueryParseContext(parser));
        }
        catch (IOException | ParsingException e) {
            log.error((Object)("Invalid query: " + query + ": " + e.getMessage()), e);
            throw new IllegalArgumentException("Bad query: " + query);
        }
        return searchSourceBuilder;
    }

    public String expandQueryVariables(String query, Object[] params) {
        HashMap<String, Object> qParams = new HashMap<String, Object>();
        for (int i = 0; i < params.length; ++i) {
            query = query.replaceFirst("\\?", "\\${param" + i + "}");
            qParams.put("param" + i, params[i]);
        }
        return this.expandQueryVariables(query, qParams);
    }

    public String expandQueryVariables(String query, Map<String, Object> params) {
        if (params != null && params.size() > 0) {
            TextTemplate tmpl = new TextTemplate();
            for (String key : params.keySet()) {
                Object val = params.get(key);
                if (val == null) continue;
                if (val instanceof Calendar) {
                    tmpl.setVariable(key, Long.toString(((Calendar)val).getTime().getTime()));
                    continue;
                }
                if (val instanceof Date) {
                    tmpl.setVariable(key, Long.toString(((Date)val).getTime()));
                    continue;
                }
                tmpl.setVariable(key, val.toString());
            }
            query = tmpl.processText(query);
        }
        return query;
    }

    public List<?> nativeQuery(String query, Map<String, Object> params, int pageNb, int pageSize) {
        SearchRequest request = this.buildQuery(query, params);
        if (pageNb > 0) {
            request.source().from(pageNb * pageSize);
        }
        if (pageSize > 0) {
            request.source().size(pageSize);
        }
        this.logSearchRequest(request);
        SearchResponse searchResponse = this.esClient.search(request);
        this.logSearchResponse(searchResponse);
        return this.buildLogEntries(searchResponse);
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String[] categories, String path, int pageNb, int pageSize) {
        SearchRequest request = this.createSearchRequest();
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        if (eventIds != null && eventIds.length > 0) {
            if (eventIds.length == 1) {
                filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"eventId", (String)eventIds[0]));
            } else {
                filterBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"eventId", (String[])eventIds));
            }
        }
        if (categories != null && categories.length > 0) {
            if (categories.length == 1) {
                filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"category", (String)categories[0]));
            } else {
                filterBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"category", (String[])categories));
            }
        }
        if (path != null) {
            filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"docPath", (String)path));
        }
        if (limit != null) {
            filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"eventDate").lt(this.convertDate(limit)));
        }
        request.source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)filterBuilder)));
        if (pageNb > 0) {
            request.source().from(pageNb * pageSize);
        }
        if (pageSize > 0) {
            request.source().size(pageSize);
        }
        this.logSearchRequest(request);
        SearchResponse searchResponse = this.esClient.search(request);
        this.logSearchResponse(searchResponse);
        return this.buildLogEntries(searchResponse);
    }

    public void addLogEntries(List<LogEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        JsonFactory factory = new JsonFactory();
        UIDGeneratorService uidGeneratorService = (UIDGeneratorService)Framework.getService(UIDGeneratorService.class);
        UIDSequencer seq = uidGeneratorService.getSequencer();
        try {
            for (LogEntry entry : entries) {
                entry.setId((long)seq.getNext(SEQ_NAME));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Indexing log entry: %s", entry));
                }
                entry.setLogDate(new Date());
                BytesStreamOutput out = new BytesStreamOutput();
                JsonGenerator jsonGen = factory.createGenerator((OutputStream)out);
                XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)out);
                ObjectMapper mapper = new ObjectMapper();
                mapper.writeValue(jsonGen, (Object)entry);
                bulkRequest.add(new IndexRequest(this.getESIndexName(), "entry", String.valueOf(entry.getId())).source(builder));
            }
            BulkResponse bulkResponse = this.esClient.bulk(bulkRequest);
            if (bulkResponse.hasFailures()) {
                for (BulkItemResponse response : bulkResponse.getItems()) {
                    if (!response.isFailed()) continue;
                    log.error((Object)("Unable to index audit entry " + response.getItemId() + " :" + response.getFailureMessage()));
                }
            }
        }
        catch (IOException e) {
            throw new NuxeoException("Error while indexing Audit entries", (Throwable)e);
        }
    }

    public Long getEventsCount(String eventId) {
        SearchResponse res = this.esClient.search(new SearchRequest(new String[]{this.getESIndexName()}).types(new String[]{"entry"}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termQuery((String)"eventId", (String)eventId))).size(0)));
        return res.getHits().getTotalHits();
    }

    public long syncLogCreationEntries(String repoId, String path, Boolean recurs) {
        return this.syncLogCreationEntries(this.provider, repoId, path, recurs);
    }

    public SearchResponse search(SearchRequest request) {
        String[] indices = request.indices();
        if (indices == null || indices.length != 1) {
            throw new IllegalStateException("Search on audit must include index name: " + request);
        }
        if (!this.getESIndexName().equals(indices[0])) {
            throw new IllegalStateException("Search on audit must be on audit index: " + request);
        }
        return this.esClient.search(request);
    }

    protected QueryBuilder buildFilter(PredicateDefinition[] predicates, DocumentModel searchDocumentModel) {
        if (searchDocumentModel == null) {
            return QueryBuilders.matchAllQuery();
        }
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        int nbFilters = 0;
        for (PredicateDefinition predicate : predicates) {
            PredicateFieldDefinition[] fieldDef = predicate.getValues();
            Object[] val = new Object[fieldDef.length];
            for (int fidx = 0; fidx < fieldDef.length; ++fidx) {
                val[fidx] = fieldDef[fidx].getXpath() != null ? searchDocumentModel.getPropertyValue(fieldDef[fidx].getXpath()) : searchDocumentModel.getProperty(fieldDef[fidx].getSchema(), fieldDef[fidx].getName());
            }
            if (!this.isNonNullParam(val)) continue;
            ++nbFilters;
            String op = predicate.getOperator();
            if (op.equalsIgnoreCase("IN")) {
                String[] values = null;
                if (val[0] instanceof Iterable) {
                    ArrayList<String> l = new ArrayList<String>();
                    Iterable vals = (Iterable)val[0];
                    for (Object v : vals) {
                        if (v == null) continue;
                        l.add(v.toString());
                    }
                    values = l.toArray(new String[l.size()]);
                } else if (val[0] instanceof Object[]) {
                    values = (String[])val[0];
                }
                filterBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)predicate.getParameter(), values));
                continue;
            }
            if (op.equalsIgnoreCase("BETWEEN")) {
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).gt(this.convertDate(val[0])));
                if (val.length <= 1) continue;
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).lt(this.convertDate(val[1])));
                continue;
            }
            if (">".equals(op)) {
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).gt(this.convertDate(val[0])));
                continue;
            }
            if (">=".equals(op)) {
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).gte(this.convertDate(val[0])));
                continue;
            }
            if ("<".equals(op)) {
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).lt(this.convertDate(val[0])));
                continue;
            }
            if ("<=".equals(op)) {
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).lte(this.convertDate(val[0])));
                continue;
            }
            filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)predicate.getParameter(), (Object)this.convertDate(val[0])));
        }
        if (nbFilters == 0) {
            return QueryBuilders.matchAllQuery();
        }
        return filterBuilder;
    }

    protected Object convertDate(Object o) {
        if (o instanceof Calendar) {
            return ((Calendar)o).getTime().getTime();
        }
        if (o instanceof Date) {
            return ((Date)o).getTime();
        }
        return o;
    }

    public SearchRequest buildSearchQuery(String fixedPart, PredicateDefinition[] predicates, DocumentModel searchDocumentModel) {
        SearchRequest request = this.createSearchRequest();
        WrapperQueryBuilder queryBuilder = QueryBuilders.wrapperQuery((String)fixedPart);
        QueryBuilder filterBuilder = this.buildFilter(predicates, searchDocumentModel);
        request.source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).filter(filterBuilder)));
        return request;
    }

    protected boolean isNonNullParam(Object[] val) {
        if (val == null) {
            return false;
        }
        for (Object v : val) {
            if (v == null) continue;
            if (v instanceof String) {
                if (((String)v).isEmpty()) continue;
                return true;
            }
            if (v instanceof String[]) {
                if (((String[])v).length <= 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public String migrate(int batchSize) {
        String MIGRATION_WORK_ID = "AuditMigration";
        WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
        Work.State migrationState = wm.getWorkState("AuditMigration");
        if (migrationState != null) {
            return "Migration already scheduled : " + migrationState.toString();
        }
        ESAuditMigrationWork migrationWork = new ESAuditMigrationWork("AuditMigration", batchSize);
        wm.schedule((Work)migrationWork);
        return "Migration work started : AuditMigration";
    }

    protected void logSearchResponse(SearchResponse response) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response: " + response.toString()));
        }
    }

    protected void logSearchRequest(SearchRequest request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Search query: curl -XGET 'http://localhost:9200/%s/%s/_search?pretty' -d '%s'", this.getESIndexName(), "entry", request.toString()));
        }
    }

    protected void ensureUIDSequencer(ESClient esClient) {
        boolean auditIndexExists = esClient.indexExists(this.getESIndexName());
        if (!auditIndexExists) {
            return;
        }
        SearchRequest request = this.createSearchRequest();
        request.source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).aggregation((AggregationBuilder)AggregationBuilders.max((String)"maxAgg").field("id")));
        SearchResponse searchResponse = esClient.search(request);
        Max agg = (Max)searchResponse.getAggregations().get("maxAgg");
        int maxLogEntryId = (int)agg.getValue();
        UIDGeneratorService uidGeneratorService = (UIDGeneratorService)Framework.getService(UIDGeneratorService.class);
        UIDSequencer seq = uidGeneratorService.getSequencer();
        seq.init();
        int nextSequenceId = seq.getNext(SEQ_NAME);
        if (nextSequenceId < maxLogEntryId) {
            log.info((Object)String.format("Next UID returned by %s sequence is %d, initializing sequence to %d", SEQ_NAME, nextSequenceId, maxLogEntryId));
            seq.initSequence(SEQ_NAME, maxLogEntryId);
        }
    }

    public ExtendedInfo newExtendedInfo(Serializable value) {
        return new ESExtendedInfo(value);
    }

    protected String getESIndexName() {
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        return esa.getIndexNameForType("entry");
    }
}

