/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.seqgen;

import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.seqgen.SequenceGenerator;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class ESSequenceGeneratorComponent
extends DefaultComponent
implements SequenceGenerator {
    public static final String IDX_NAME = "sequence";
    public static final String IDX_TYPE = "seqId";
    protected Client esClient = null;

    protected Client getClient() {
        if (this.esClient == null) {
            ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
            this.esClient = esa.getClient();
        }
        return this.esClient;
    }

    @Override
    public long getNextId(String sequenceName) {
        String source = "{ \"ts\" : " + System.currentTimeMillis() + "}";
        IndexResponse res = (IndexResponse)this.getClient().prepareIndex(IDX_NAME, IDX_TYPE, sequenceName).setSource(source).execute().actionGet();
        return res.getVersion();
    }

    public void deactivate(ComponentContext context) {
        if (this.esClient != null) {
            this.esClient.close();
        }
    }
}

