/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.seqgen;

import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.nuxeo.ecm.platform.uidgen.UIDSequencer;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.runtime.api.Framework;

public class ESUIDSequencer
implements UIDSequencer {
    public static final String SEQUENCER_CONTRIB = "esSequencer";
    public static final String IDX_NAME = "uidgen";
    public static final String IDX_TYPE = "seqId";
    protected Client esClient = null;

    protected Client getClient() {
        if (this.esClient == null) {
            ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
            this.esClient = esa.getClient();
        }
        return this.esClient;
    }

    public void dispose() {
        if (this.esClient != null) {
            this.esClient.close();
        }
    }

    public int getNext(String sequenceName) {
        String source = "{ \"ts\" : " + System.currentTimeMillis() + "}";
        IndexResponse res = (IndexResponse)this.getClient().prepareIndex(IDX_NAME, IDX_TYPE, sequenceName).setSource(source).execute().actionGet();
        return (int)res.getVersion();
    }

    public void init() {
        this.getClient();
    }
}

