/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context.jts;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.util.ArrayList;
import java.util.List;

public class JtsSpatialContext
extends SpatialContext {
    public static final JtsSpatialContext GEO;
    protected final GeometryFactory geometryFactory;
    protected final boolean allowMultiOverlap;
    protected final boolean useJtsPoint;
    protected final boolean useJtsLineString;

    public JtsSpatialContext(JtsSpatialContextFactory factory) {
        super(factory);
        this.geometryFactory = factory.getGeometryFactory();
        this.allowMultiOverlap = factory.allowMultiOverlap;
        this.useJtsPoint = factory.useJtsPoint;
        this.useJtsLineString = factory.useJtsLineString;
    }

    public boolean isAllowMultiOverlap() {
        return this.allowMultiOverlap;
    }

    @Override
    public double normX(double x) {
        x = super.normX(x);
        return this.geometryFactory.getPrecisionModel().makePrecise(x);
    }

    @Override
    public double normY(double y) {
        y = super.normY(y);
        return this.geometryFactory.getPrecisionModel().makePrecise(y);
    }

    @Override
    public String toString(Shape shape) {
        if (shape instanceof JtsGeometry) {
            JtsGeometry jtsGeom = (JtsGeometry)shape;
            return jtsGeom.getGeom().toText();
        }
        return super.toString(shape);
    }

    public Geometry getGeometryFrom(Shape shape) {
        if (shape instanceof JtsGeometry) {
            return ((JtsGeometry)shape).getGeom();
        }
        if (shape instanceof JtsPoint) {
            return ((JtsPoint)shape).getGeom();
        }
        if (shape instanceof Point) {
            Point point = (Point)shape;
            return this.geometryFactory.createPoint(new Coordinate(point.getX(), point.getY()));
        }
        if (shape instanceof Rectangle) {
            Rectangle r = (Rectangle)shape;
            if (r.getCrossesDateLine()) {
                ArrayList<Geometry> pair = new ArrayList<Geometry>(2);
                pair.add(this.geometryFactory.toGeometry(new Envelope(r.getMinX(), this.getWorldBounds().getMaxX(), r.getMinY(), r.getMaxY())));
                pair.add(this.geometryFactory.toGeometry(new Envelope(this.getWorldBounds().getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY())));
                return this.geometryFactory.buildGeometry(pair);
            }
            return this.geometryFactory.toGeometry(new Envelope(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY()));
        }
        if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            if (circle.getBoundingBox().getCrossesDateLine()) {
                throw new IllegalArgumentException("Doesn't support dateline cross yet: " + circle);
            }
            GeometricShapeFactory gsf = new GeometricShapeFactory(this.geometryFactory);
            gsf.setSize(circle.getBoundingBox().getWidth());
            gsf.setNumPoints(100);
            gsf.setCentre(new Coordinate(circle.getCenter().getX(), circle.getCenter().getY()));
            return gsf.createCircle();
        }
        throw new InvalidShapeException("can't make Geometry from: " + shape);
    }

    public boolean useJtsPoint() {
        return this.useJtsPoint;
    }

    @Override
    public Point makePoint(double x, double y) {
        if (!this.useJtsPoint()) {
            return super.makePoint(x, y);
        }
        this.verifyX(x);
        this.verifyY(y);
        Coordinate coord = Double.isNaN(x) ? null : new Coordinate(x, y);
        return new JtsPoint(this.geometryFactory.createPoint(coord), this);
    }

    public boolean useJtsLineString() {
        return this.useJtsLineString;
    }

    @Override
    public Shape makeLineString(List<Point> points) {
        if (!this.useJtsLineString()) {
            return super.makeLineString(points);
        }
        Coordinate[] coords = new Coordinate[points.size()];
        for (int i = 0; i < coords.length; ++i) {
            Point p = points.get(i);
            if (p instanceof JtsPoint) {
                JtsPoint jtsPoint = (JtsPoint)p;
                coords[i] = jtsPoint.getGeom().getCoordinate();
                continue;
            }
            coords[i] = new Coordinate(p.getX(), p.getY());
        }
        LineString lineString = this.geometryFactory.createLineString(coords);
        return this.makeShape((Geometry)lineString);
    }

    public JtsGeometry makeShape(Geometry geom, boolean dateline180Check, boolean allowMultiOverlap) {
        return new JtsGeometry(geom, this, dateline180Check, allowMultiOverlap);
    }

    public JtsGeometry makeShape(Geometry geom) {
        return this.makeShape(geom, true, this.allowMultiOverlap);
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    @Override
    public String toString() {
        if (this.equals(GEO)) {
            return GEO.getClass().getSimpleName() + ".GEO";
        }
        return super.toString();
    }

    static {
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.geo = true;
        GEO = new JtsSpatialContext(factory);
    }
}

