/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.transport.TransportAddressSerializers;

public class DiscoveryNode
implements Streamable,
Serializable {
    public static final ImmutableList<DiscoveryNode> EMPTY_LIST = ImmutableList.of();
    private String nodeName = "";
    private String nodeId;
    private String hostName;
    private String hostAddress;
    private TransportAddress address;
    private ImmutableMap<String, String> attributes;
    private Version version = Version.CURRENT;

    public static boolean localNode(Settings settings) {
        if (settings.get("node.local") != null) {
            return settings.getAsBoolean("node.local", (Boolean)false);
        }
        if (settings.get("node.mode") != null) {
            String nodeMode = settings.get("node.mode");
            if ("local".equals(nodeMode)) {
                return true;
            }
            if ("network".equals(nodeMode)) {
                return false;
            }
            throw new ElasticsearchIllegalArgumentException("unsupported node.mode [" + nodeMode + "]. Should be one of [local, network].");
        }
        return false;
    }

    public static boolean nodeRequiresLocalStorage(Settings settings) {
        return settings.getAsBoolean("node.client", (Boolean)false) == false && (settings.getAsBoolean("node.data", (Boolean)true) != false || settings.getAsBoolean("node.master", (Boolean)true) != false);
    }

    public static boolean clientNode(Settings settings) {
        String client = settings.get("node.client");
        return client != null && client.equals("true");
    }

    public static boolean masterNode(Settings settings) {
        String master = settings.get("node.master");
        if (master == null) {
            return !DiscoveryNode.clientNode(settings);
        }
        return master.equals("true");
    }

    public static boolean dataNode(Settings settings) {
        String data = settings.get("node.data");
        if (data == null) {
            return !DiscoveryNode.clientNode(settings);
        }
        return data.equals("true");
    }

    DiscoveryNode() {
    }

    public DiscoveryNode(String nodeId, TransportAddress address, Version version) {
        this("", nodeId, address, ImmutableMap.of(), version);
    }

    public DiscoveryNode(String nodeName, String nodeId, TransportAddress address, Map<String, String> attributes, Version version) {
        this(nodeName, nodeId, NetworkUtils.getLocalHostName(""), NetworkUtils.getLocalHostAddress(""), address, attributes, version);
    }

    public DiscoveryNode(String nodeName, String nodeId, String hostName, String hostAddress, TransportAddress address, Map<String, String> attributes, Version version) {
        if (nodeName != null) {
            this.nodeName = nodeName.intern();
        }
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            builder.put(entry.getKey().intern(), entry.getValue().intern());
        }
        this.attributes = builder.build();
        this.nodeId = nodeId.intern();
        this.hostName = hostName.intern();
        this.hostAddress = hostAddress.intern();
        this.address = address;
        this.version = version;
    }

    public boolean shouldConnectTo(DiscoveryNode otherNode) {
        return !this.clientNode() || !otherNode.clientNode();
    }

    public TransportAddress address() {
        return this.address;
    }

    public TransportAddress getAddress() {
        return this.address();
    }

    public String id() {
        return this.nodeId;
    }

    public String getId() {
        return this.id();
    }

    public String name() {
        return this.nodeName;
    }

    public String getName() {
        return this.name();
    }

    public ImmutableMap<String, String> attributes() {
        return this.attributes;
    }

    public ImmutableMap<String, String> getAttributes() {
        return this.attributes();
    }

    public boolean dataNode() {
        String data = this.attributes.get("data");
        if (data == null) {
            return !this.clientNode();
        }
        return data.equals("true");
    }

    public boolean isDataNode() {
        return this.dataNode();
    }

    public boolean clientNode() {
        String client = this.attributes.get("client");
        return client != null && client.equals("true");
    }

    public boolean isClientNode() {
        return this.clientNode();
    }

    public boolean masterNode() {
        String master = this.attributes.get("master");
        if (master == null) {
            return !this.clientNode();
        }
        return master.equals("true");
    }

    public boolean isMasterNode() {
        return this.masterNode();
    }

    public Version version() {
        return this.version;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public Version getVersion() {
        return this.version;
    }

    public static DiscoveryNode readNode(StreamInput in) throws IOException {
        DiscoveryNode node = new DiscoveryNode();
        node.readFrom(in);
        return node;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.nodeName = in.readString().intern();
        this.nodeId = in.readString().intern();
        this.hostName = in.readString().intern();
        this.hostAddress = in.readString().intern();
        this.address = TransportAddressSerializers.addressFromStream(in);
        int size = in.readVInt();
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            builder.put(in.readString().intern(), in.readString().intern());
        }
        this.attributes = builder.build();
        this.version = Version.readVersion(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        out.writeString(this.nodeId);
        out.writeString(this.hostName);
        out.writeString(this.hostAddress);
        TransportAddressSerializers.addressToStream(out, this.address);
        out.writeVInt(this.attributes.size());
        for (Map.Entry entry : this.attributes.entrySet()) {
            out.writeString((String)entry.getKey());
            out.writeString((String)entry.getValue());
        }
        Version.writeVersion(this.version, out);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DiscoveryNode)) {
            return false;
        }
        DiscoveryNode other = (DiscoveryNode)obj;
        return this.nodeId.equals(other.nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.nodeName.length() > 0) {
            sb.append('[').append(this.nodeName).append(']');
        }
        if (this.nodeId != null) {
            sb.append('[').append(this.nodeId).append(']');
        }
        if (Strings.hasLength(this.hostName)) {
            sb.append('[').append(this.hostName).append(']');
        }
        if (this.address != null) {
            sb.append('[').append(this.address).append(']');
        }
        if (!this.attributes.isEmpty()) {
            sb.append(this.attributes);
        }
        return sb.toString();
    }
}

