/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.url;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.url.URLBlobStore;
import org.elasticsearch.common.collect.ImmutableMap;

public abstract class AbstractURLBlobContainer
extends AbstractBlobContainer {
    protected final URLBlobStore blobStore;
    protected final URL path;

    public AbstractURLBlobContainer(URLBlobStore blobStore, BlobPath blobPath, URL path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    public URL url() {
        return this.path;
    }

    @Override
    public ImmutableMap<String, BlobMetaData> listBlobs() throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public boolean deleteBlob(String blobName) throws IOException {
        throw new UnsupportedOperationException("URL repository is read only");
    }

    @Override
    public boolean blobExists(String blobName) {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public void readBlob(final String blobName, final BlobContainer.ReadBlobListener listener) {
        this.blobStore.executor().execute(new Runnable(){

            @Override
            public void run() {
                byte[] buffer = new byte[AbstractURLBlobContainer.this.blobStore.bufferSizeInBytes()];
                InputStream is = null;
                try {
                    int bytesRead;
                    is = new URL(AbstractURLBlobContainer.this.path, blobName).openStream();
                    while ((bytesRead = is.read(buffer)) != -1) {
                        listener.onPartial(buffer, 0, bytesRead);
                    }
                }
                catch (Throwable t) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                    listener.onFailure(t);
                    return;
                }
                try {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                    listener.onCompleted();
                }
                catch (Throwable t) {
                    listener.onFailure(t);
                }
            }
        });
    }
}

