/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.util.Collection;
import java.util.Comparator;
import org.elasticsearch.common.primitives.Longs;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;

public interface Histogram
extends MultiBucketsAggregation {
    public Collection<? extends Bucket> getBuckets();

    public Bucket getBucketByKey(String var1);

    public Bucket getBucketByKey(Number var1);

    public static abstract class Order
    implements ToXContent {
        public static final Order KEY_ASC = new InternalOrder(1, "_key", true, new Comparator<InternalHistogram.Bucket>(){

            @Override
            public int compare(InternalHistogram.Bucket b1, InternalHistogram.Bucket b2) {
                return Longs.compare(b1.key, b2.key);
            }
        });
        public static final Order KEY_DESC = new InternalOrder(2, "_key", false, new Comparator<InternalHistogram.Bucket>(){

            @Override
            public int compare(InternalHistogram.Bucket b1, InternalHistogram.Bucket b2) {
                return -Longs.compare(b1.key, b2.key);
            }
        });
        public static final Order COUNT_ASC = new InternalOrder(3, "_count", true, new Comparator<InternalHistogram.Bucket>(){

            @Override
            public int compare(InternalHistogram.Bucket b1, InternalHistogram.Bucket b2) {
                int cmp = Longs.compare(b1.getDocCount(), b2.getDocCount());
                if (cmp == 0) {
                    cmp = Longs.compare(b1.key, b2.key);
                }
                return cmp;
            }
        });
        public static final Order COUNT_DESC = new InternalOrder(4, "_count", false, new Comparator<InternalHistogram.Bucket>(){

            @Override
            public int compare(InternalHistogram.Bucket b1, InternalHistogram.Bucket b2) {
                int cmp = -Longs.compare(b1.getDocCount(), b2.getDocCount());
                if (cmp == 0) {
                    cmp = Longs.compare(b1.key, b2.key);
                }
                return cmp;
            }
        });

        public static Order aggregation(String path, boolean asc) {
            return new InternalOrder.Aggregation(path, asc);
        }

        public static Order aggregation(String aggregationName, String valueName, boolean asc) {
            return new InternalOrder.Aggregation(aggregationName + "." + valueName, asc);
        }

        abstract Comparator<InternalHistogram.Bucket> comparator();
    }

    public static interface Bucket
    extends MultiBucketsAggregation.Bucket {
        public Number getKeyAsNumber();
    }
}

