/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.elasticsearch.query.NxqlQueryConverter;
import org.nuxeo.runtime.api.Framework;

public class NxQueryBuilder {
    private static final int DEFAULT_LIMIT = 10;
    private int limit = 10;
    private final CoreSession session;
    private int offset = 0;
    private List<SortInfo> sortInfos = new ArrayList<SortInfo>();
    private String nxql;
    private QueryBuilder esQueryBuilder;
    private boolean fetchFromElasticsearch = false;

    public NxQueryBuilder(CoreSession coreSession) {
        this.session = coreSession;
        this.fetchFromElasticsearch = Boolean.parseBoolean(Framework.getProperty((String)"elasticsearch.fetchDocFromEs", (String)"false"));
    }

    public NxQueryBuilder limit(int limit) {
        this.limit = limit;
        return this;
    }

    public NxQueryBuilder offset(int offset) {
        this.offset = offset;
        return this;
    }

    public NxQueryBuilder addSort(SortInfo sortInfo) {
        this.sortInfos.add(sortInfo);
        return this;
    }

    public NxQueryBuilder addSort(SortInfo[] sortInfos) {
        if (sortInfos != null && sortInfos.length > 0) {
            Collections.addAll(this.sortInfos, sortInfos);
        }
        return this;
    }

    public NxQueryBuilder nxql(String nxql) {
        this.nxql = nxql;
        this.esQueryBuilder = null;
        return this;
    }

    public NxQueryBuilder esQuery(QueryBuilder queryBuilder) {
        this.esQueryBuilder = queryBuilder;
        this.nxql = null;
        return this;
    }

    public NxQueryBuilder fetchFromElasticsearch() {
        this.fetchFromElasticsearch = true;
        return this;
    }

    public NxQueryBuilder fetchFromDatabase() {
        this.fetchFromElasticsearch = false;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<SortInfo> getSortInfos() {
        return this.sortInfos;
    }

    public String getNxql() {
        return this.nxql;
    }

    public boolean isFetchFromElasticsearch() {
        return this.fetchFromElasticsearch;
    }

    public CoreSession getSession() {
        return this.session;
    }

    public QueryBuilder makeQuery() {
        if (this.esQueryBuilder == null && this.nxql != null) {
            this.esQueryBuilder = NxqlQueryConverter.toESQueryBuilder(this.nxql);
            if (this.nxql.toLowerCase().contains("order by")) {
                List<SortInfo> builtInSortInfos = NxqlQueryConverter.getSortInfo(this.nxql);
                this.sortInfos.addAll(builtInSortInfos);
            }
        }
        return this.esQueryBuilder;
    }

    public SortBuilder[] getSortBuilders() {
        if (this.sortInfos.isEmpty()) {
            return new SortBuilder[0];
        }
        SortBuilder[] ret = new SortBuilder[this.sortInfos.size()];
        int i = 0;
        for (SortInfo sortInfo : this.sortInfos) {
            ret[i++] = new FieldSortBuilder(sortInfo.getSortColumn()).order(sortInfo.getSortAscending() ? SortOrder.ASC : SortOrder.DESC);
        }
        return ret;
    }
}

