/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.etcd;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.representation.Form;
import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.etcd.EtcdConfigurationDescriptor;
import org.nuxeo.etcd.EtcdResult;
import org.nuxeo.etcd.EtcdService;
import org.nuxeo.etcd.retrier.EtcdRetrier;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class EtcdServiceImpl
extends DefaultComponent
implements EtcdService {
    private static final Log log = LogFactory.getLog(EtcdServiceImpl.class);
    public static final String CONFIGURATION_EP = "configuration";
    public static final String ETCD_URL_FORMAT = "%s/v2/keys/";
    protected EtcdConfigurationDescriptor configuration = new EtcdConfigurationDescriptor();
    protected Client client;
    protected WebResource service;

    public void activate(ComponentContext context) {
        DefaultClientConfig config = new DefaultClientConfig();
        this.client = Client.create((ClientConfig)config);
    }

    @Override
    public EtcdResult set(String key, String value) {
        return this.set(key, value, -1);
    }

    protected String computeURL() {
        String endpoint = this.configuration.getEndpoint();
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        return String.format(ETCD_URL_FORMAT, endpoint);
    }

    @Override
    public EtcdResult set(String key, String value, int ttl) {
        EtcdResult res = this.doSet(key, value, ttl);
        if (res == null) {
            ((EtcdRetrier)((Object)Framework.getService(EtcdRetrier.class))).saveSet(key, value, ttl);
        }
        return res;
    }

    public EtcdResult doSet(String key, String value, int ttl) {
        ClientResponse response;
        int status;
        WebResource webResource = this.service.path(key);
        Form form = new Form();
        form.add("value", value);
        if (ttl > 0) {
            form.add("ttl", (Object)ttl);
        }
        if ((status = (response = (ClientResponse)webResource.put(ClientResponse.class, (Object)form)).getStatus()) != Response.Status.CREATED.getStatusCode() && status != Response.Status.OK.getStatusCode()) {
            String message = "Error while setting '%s' key on etcd. Status code: %d";
            log.error((Object)String.format(message, key, response.getStatus()));
        } else {
            try {
                ObjectMapper mapper = new ObjectMapper();
                return (EtcdResult)mapper.readValue(response.getEntityInputStream(), EtcdResult.class);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public EtcdResult get(String key) {
        WebResource webResource = this.service.path(key);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        if (response.getStatus() != Response.Status.OK.getStatusCode() && response.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
            String message = "Error while getting '%s' key on etcd. Status code: %d";
            log.error((Object)String.format(message, key, response.getStatus()));
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            EtcdResult result = (EtcdResult)mapper.readValue(response.getEntityInputStream(), EtcdResult.class);
            return result.errorCode == 100 ? null : result;
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    @Override
    public String getValue(String key) {
        EtcdResult result = this.get(key);
        return result != null && result.node != null ? result.node.value : null;
    }

    @Override
    public EtcdResult delete(String key) {
        return this.delete(key, false);
    }

    @Override
    public EtcdResult delete(String key, boolean recursive) {
        ClientResponse response;
        WebResource webResource = this.service.path(key);
        if (recursive) {
            webResource = webResource.queryParam("recursive", "true");
        }
        if ((response = (ClientResponse)webResource.delete(ClientResponse.class)).getStatus() != Response.Status.OK.getStatusCode()) {
            String message = "Error while getting '%s' key on etcd. Status code: %d";
            log.error((Object)String.format(message, key, response.getStatus()));
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (EtcdResult)mapper.readValue(response.getEntityInputStream(), EtcdResult.class);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_EP.equalsIgnoreCase(extensionPoint)) {
            this.configuration = (EtcdConfigurationDescriptor)contribution;
            this.service = this.client.resource(this.computeURL());
        } else {
            log.warn((Object)("Trying to register a contribution for an unknown extension point: " + extensionPoint));
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return adapter.cast(this);
        }
        if (adapter.isAssignableFrom(EtcdRetrier.class)) {
            return adapter.cast((Object)EtcdRetrier.newInstance());
        }
        return null;
    }
}

