/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.etcd.retrier;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.etcd.EtcdResult;
import org.nuxeo.etcd.EtcdService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class EtcdRetrier
extends DefaultComponent {
    protected boolean working = false;
    public static final String DIRECTORY_NAME = "etcdAction";
    public static final String SCHEMA_NAME = "etcd_action";
    private static final Log log = LogFactory.getLog(EtcdRetrier.class);

    public static EtcdRetrier newInstance() {
        return new EtcdRetrier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retry() {
        this.working = true;
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        Session session = directoryService.open(DIRECTORY_NAME);
        try {
            DocumentModelList entries = session.query(new HashMap());
            for (DocumentModel entry : entries) {
                this.handleEntry(session, entry);
            }
        }
        finally {
            this.working = false;
            session.close();
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    protected void handleEntry(Session session, DocumentModel entry) {
        EtcdResult res;
        String action = (String)((Object)entry.getPropertyValue("action"));
        if (action.equals(ACTION.SET.toString())) {
            res = this.set(entry);
        } else {
            log.error((Object)String.format("Not supported action (%s), ignored", action));
            res = new EtcdResult();
        }
        if (res != null) {
            session.deleteEntry(entry);
        }
    }

    protected EtcdResult set(DocumentModel entry) {
        EtcdService etcdService = (EtcdService)Framework.getService(EtcdService.class);
        int ttl = ((Long)entry.getPropertyValue("ttl")).intValue();
        return etcdService.set((String)((Object)entry.getPropertyValue("key")), (String)((Object)entry.getPropertyValue("value")), ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSet(String key, String value, int ttl) {
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        Session session = directoryService.open(DIRECTORY_NAME);
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put("key", key);
        entry.put("action", ACTION.SET.toString());
        entry.put("value", value);
        entry.put("ttl", ttl);
        try {
            if (session.hasEntry(key)) {
                DocumentModel doc = session.getEntry(key);
                entry.remove("key");
                doc.setProperties(SCHEMA_NAME, entry);
                session.updateEntry(doc);
            } else {
                session.createEntry(entry);
            }
        }
        finally {
            session.close();
        }
    }

    public static enum ACTION {
        SET,
        DELETE;

    }
}

