/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.adapter;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;

public class IoClient {
    protected DocumentModel doc;

    public IoClient(DocumentModel doc) {
        this.doc = doc;
    }

    public String getId() {
        return this.doc.getId();
    }

    public String getName() {
        return this.doc.getName();
    }

    public String getPath() {
        return this.doc.getPathAsString();
    }

    public String getTitle() {
        try {
            return this.doc.getTitle();
        }
        catch (ClientException e) {
            return "";
        }
    }

    public long getLimit() {
        try {
            return (Long)this.doc.getPropertyValue("ioclient:envLimit");
        }
        catch (ClientException e) {
            return 0L;
        }
    }

    @JsonIgnore
    public DocumentModel getDocument() throws ClientException {
        return this.doc;
    }
}

