/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.io.adapter.IoClient;
import org.nuxeo.runtime.api.Framework;

public class IoUser {
    protected String username;
    protected String firstName;
    protected String lastName;
    protected String company;
    protected String email;
    protected boolean isAdministrator;
    protected List<IoClient> clients;
    protected List<ConnectProject> projects;

    public IoUser(NuxeoPrincipal principal, List<IoClient> clients, List<ConnectProject> projects) {
        this.username = principal.getName();
        this.firstName = principal.getFirstName();
        this.lastName = principal.getLastName();
        this.company = principal.getCompany();
        this.email = principal.getEmail();
        this.isAdministrator = principal.isAdministrator();
        this.clients = new ArrayList<IoClient>();
        this.clients.addAll(clients);
        Collections.sort(projects, new Comparator<ConnectProject>(){

            @Override
            public int compare(ConnectProject o1, ConnectProject o2) {
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
        this.projects = new ArrayList<ConnectProject>();
        this.projects.addAll(projects);
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCompany() {
        return this.company;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isAdministrator() {
        return this.isAdministrator;
    }

    public List<IoClient> getClients() {
        return this.clients;
    }

    public List<ConnectProject> getProjects() {
        return this.projects;
    }

    public String getDefaultDomainSuffix() {
        return Framework.getProperty((String)"org.nuxeo.io.defaultDomainSuffix");
    }

    public boolean isBlockDomainSuffix() {
        return Framework.isBooleanPropertyTrue((String)"org.nuxeo.io.blockDomainSuffix");
    }

    public String getConnectURL() {
        return Framework.getProperty((String)"org.nuxeo.connect.url");
    }
}

