/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.connect;

import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.io.connect.IoConnectClient;
import org.nuxeo.runtime.api.Framework;

public class InstanceRegistrator {
    private static final Log log = LogFactory.getLog(InstanceRegistrator.class);
    protected String projectId;
    protected String description;
    protected NuxeoClientInstanceType type;

    public InstanceRegistrator(String projectId, String description, NuxeoClientInstanceType type) {
        this.projectId = projectId;
        this.description = description;
        this.type = type;
    }

    public LogicalInstanceIdentifier getCLIDs() {
        if (Framework.isTestModeSet()) {
            return null;
        }
        WebResource r = IoConnectClient.resource(this.registrationResource());
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"projectId", (Object)this.projectId);
        params.add((Object)"description", (Object)this.description);
        params.add((Object)"type", (Object)this.type.getValue());
        params.add((Object)"CTID", null);
        String CLIDs = (String)r.post(String.class, (Object)params);
        try {
            return new LogicalInstanceIdentifier(CLIDs, this.description);
        }
        catch (LogicalInstanceIdentifier.InvalidCLID invalidCLID) {
            log.warn((Object)invalidCLID, (Throwable)invalidCLID);
            return null;
        }
    }

    protected String registrationResource() {
        return ConnectUrlConfig.getRegistrationBaseUrl() + "remoteRegisterInstance";
    }
}

