/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.connect;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.security.Principal;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.io.connect.OauthAuthFilter;
import org.nuxeo.runtime.api.Framework;

public class IoConnectClient {
    private static final Log log = LogFactory.getLog(IoConnectClient.class);

    private IoConnectClient() {
    }

    public static Client instance() {
        Client c = Client.create();
        c.setConnectTimeout(Integer.valueOf(20000));
        return c;
    }

    public static WebResource resource(String ressource) {
        Client c = IoConnectClient.instance();
        WebResource r = c.resource(ressource);
        try (CoreSession session = CoreInstance.openCoreSession((String)((RepositoryManager)Framework.getLocalService(RepositoryManager.class)).getDefaultRepositoryName());){
            Principal principal = session.getPrincipal();
            String principalName = principal instanceof NuxeoPrincipal && StringUtils.isNotBlank((String)((NuxeoPrincipal)principal).getOriginatingUser()) ? ((NuxeoPrincipal)principal).getOriginatingUser() : principal.getName();
            r.addFilter((ClientFilter)new OauthAuthFilter(principalName));
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return r;
    }
}

