/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.connect;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import org.nuxeo.runtime.api.Framework;

public class OauthAuthFilter
extends ClientFilter {
    public static final String CONSUMER_KEY_KEY = "io.oauth.consumer.key";
    public static final String CONSUMER_SECRET_KEY = "io.oauth.consumer.secret";
    public static final String OAUTH_REALM_KEY = "io.oauth.realm";
    protected final OAuthAccessor accessor;
    protected final String realm;
    private String username;

    public OauthAuthFilter(String username) {
        this(username, Framework.getProperty((String)CONSUMER_KEY_KEY), Framework.getProperty((String)CONSUMER_SECRET_KEY));
    }

    public OauthAuthFilter(String username, String consumerKey, String consumerSecret) {
        this.username = username;
        this.realm = Framework.getProperty((String)OAUTH_REALM_KEY, (String)"NuxeoIO");
        OAuthConsumer consumer = new OAuthConsumer(null, consumerKey, consumerSecret, null);
        consumer.setProperty("oauth_signature_method", (Object)"HMAC-SHA1");
        this.accessor = new OAuthAccessor(consumer);
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        if (!cr.getHeaders().containsKey((Object)"Authorization")) {
            try {
                String uri = OAuth.addParameters((String)cr.getURI().toString(), (String[])new String[]{"opensocial_viewer_id", this.username});
                cr.setURI(new URI(uri));
                ArrayList<AbstractMap.SimpleEntry<String, String>> params = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                MultivaluedMap entity = (MultivaluedMap)cr.getEntity();
                if (entity != null) {
                    for (String key : entity.keySet()) {
                        for (String value : (List)entity.get((Object)key)) {
                            params.add(new AbstractMap.SimpleEntry<String, String>(key, value));
                        }
                    }
                }
                OAuthMessage message = this.accessor.newRequestMessage(cr.getMethod(), uri, params);
                String authentication = message.getAuthorizationHeader(this.realm);
                cr.getHeaders().add((Object)"Authorization", (Object)authentication);
            }
            catch (IOException | URISyntaxException | OAuthException e) {
                throw new ClientHandlerException("Unable to handle Oauth filter", e);
            }
        }
        return this.getNext().handle(cr);
    }
}

