/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.listener;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.io.NameValidationException;
import org.nuxeo.io.adapter.IoEnvironment;
import org.nuxeo.runtime.api.Framework;

public class DomainValidationListener
implements EventListener {
    public static Pattern FULL_DOMAIN_REGEXP = Pattern.compile("^[a-z0-9][a-z0-9\\-\\.]*$");
    public static Pattern RESTRICTED_DOMAIN_REGEXP = Pattern.compile("^[a-z0-9][a-z0-9\\-]*$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext docCtx;
        IoEnvironment environment;
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext && (environment = (IoEnvironment)((Object)(docCtx = (DocumentEventContext)ctx).getSourceDocument().getAdapter(IoEnvironment.class))) != null) {
            CoreSession session = ctx.getCoreSession();
            this.checkDomain(session, event, environment);
            ArrayList<String> envDomains = new ArrayList<String>();
            try (IterableQueryResult envDomainResults = null;){
                envDomainResults = session.queryAndFetch(String.format("SELECT ioenvironment:domain from ioEnvironment where ecm:uuid != '%s'", environment.getId()), "NXQL", new Object[0]);
                for (Map record : envDomainResults) {
                    envDomains.add((String)record.get("ioenvironment:domain"));
                }
            }
            String domain = environment.getDomain();
            if (envDomains.contains(domain)) {
                event.markBubbleException();
                String message = String.format("Domain '%s' already used.", domain);
                throw new NameValidationException(message);
            }
        }
    }

    protected void checkDomain(CoreSession session, Event event, IoEnvironment environment) throws ClientException {
        if (StringUtils.isBlank((String)environment.getDomain())) {
            this.computeDomain(session, environment);
        }
        this.validateDomain(event, environment);
    }

    protected void computeDomain(CoreSession session, IoEnvironment environment) throws ClientException {
        DocumentRef parentRef = session.getParentDocumentRef(environment.getDocument().getRef());
        DocumentModel client = session.getParentDocument(parentRef);
        String defaultDomainSuffix = this.getDefaultDomainSuffix();
        if (Framework.isBooleanPropertyTrue((String)"org.nuxeo.io.blockDomainSuffix")) {
            environment.setDomain(String.format("%s-%s", environment.getName(), client.getName()));
        } else {
            environment.setDomain(String.format("%s-%s.%s", environment.getName(), client.getName(), defaultDomainSuffix));
        }
    }

    protected void validateDomain(Event event, IoEnvironment environment) throws NameValidationException {
        String domain = environment.getDomain();
        if (Framework.isBooleanPropertyTrue((String)"org.nuxeo.io.blockDomainSuffix")) {
            if (!RESTRICTED_DOMAIN_REGEXP.matcher(domain).matches()) {
                event.markBubbleException();
                String message = String.format("Invalid domain '%s'. Domain must start with a letter or number and can only contain lowercase letters, numbers, and dashes.", domain);
                throw new NameValidationException(message);
            }
            String defaultDomainSuffix = this.getDefaultDomainSuffix();
            if (!domain.endsWith(defaultDomainSuffix)) {
                if (!domain.endsWith(".")) {
                    domain = domain + ".";
                }
                environment.setDomain(domain + defaultDomainSuffix);
            }
        } else if (!FULL_DOMAIN_REGEXP.matcher(domain).matches()) {
            event.markBubbleException();
            String message = String.format("Invalid domain name '%s'. Domain must start with a letter or number and can only contain lowercase letters, numbers, dots and dashes.", domain);
            throw new NameValidationException(message);
        }
    }

    private String getDefaultDomainSuffix() {
        return Framework.getProperty((String)"org.nuxeo.io.defaultDomainSuffix", (String)"trial.nuxeo.io");
    }
}

