/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.listener;

import java.io.Serializable;
import java.util.Map;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.io.NameValidationException;

public class EnvironmentNameValidationListener
implements EventListener {
    public static Pattern REGEXP = Pattern.compile("^[a-z][a-z0-9\\-]*$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext docCtx;
        DocumentModel doc;
        if (!"aboutToCreate".equals(event.getName())) {
            return;
        }
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext && "ioEnvironment".equals((doc = (docCtx = (DocumentEventContext)ctx).getSourceDocument()).getType())) {
            String title = doc.getTitle();
            if (!REGEXP.matcher(title).matches()) {
                event.markBubbleException();
                String message = String.format("Invalid name '%s'. Name must start with a letter and can only contain lowercase letters, numbers, and dashes.", title);
                throw new NameValidationException(message);
            }
            try (IterableQueryResult result = null;){
                Map r;
                long count;
                CoreSession session = docCtx.getCoreSession();
                DocumentModel parent = session.getDocument((DocumentRef)docCtx.getProperty("destinationRef"));
                String query = String.format("SELECT COUNT(ecm:uuid) From Document WHERE ecm:primaryType = '%s' AND dc:title = '%s' AND ecm:isCheckedInVersion = 0 AND ecm:parentId = '%s' AND ecm:isProxy = 0", "ioEnvironment", title, parent.getId());
                result = session.queryAndFetch(query, "NXQL", new Object[0]);
                if (result.size() > 0L && (count = ((Long)((Serializable)(r = (Map)result.iterator().next()).get("COUNT(ecm:uuid)"))).longValue()) > 0L) {
                    event.markBubbleException();
                    String message = String.format("The name '%s' is already taken.", title);
                    throw new NameValidationException(message);
                }
            }
        }
    }
}

