/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.listener;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.uidgen.UIDSequencer;
import org.nuxeo.io.adapter.IoEnvironment;
import org.nuxeo.io.service.IoService;
import org.nuxeo.runtime.api.Framework;

public class IoEnvironmentListener
implements EventListener {
    public static final String ENVIRONMENT_TECH_ID_KEY = "environmentTechId";
    public static final String ENV_TECH_ID_FORMAT = "nxio_%06d";

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext docCtx;
        DocumentModel doc;
        String eventName = event.getName();
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext && "ioEnvironment".equals((doc = (docCtx = (DocumentEventContext)ctx).getSourceDocument()).getType())) {
            CoreSession session = docCtx.getCoreSession();
            IoService ioService = (IoService)Framework.getLocalService(IoService.class);
            if ("documentCreated".equals(eventName)) {
                UIDSequencer uidSequencer = (UIDSequencer)Framework.getLocalService(UIDSequencer.class);
                int id = uidSequencer.getNext(ENVIRONMENT_TECH_ID_KEY);
                String techId = String.format(ENV_TECH_ID_FORMAT, id);
                doc.setPropertyValue("ioenvironment:techId", (Serializable)((Object)techId));
                ioService.createEnvironment((IoEnvironment)((Object)doc.getAdapter(IoEnvironment.class)));
            } else if ("beforeDocumentModification".equals(eventName)) {
                Property property = doc.getProperty("ioenvironment:domain");
                if (property.isDirty()) {
                    DocumentModel oldEnvironment = session.getDocument(doc.getRef());
                    ioService.updateEnvironment((IoEnvironment)((Object)oldEnvironment.getAdapter(IoEnvironment.class)), (IoEnvironment)((Object)doc.getAdapter(IoEnvironment.class)));
                }
            } else if ("aboutToRemove".equals(eventName)) {
                ioService.deleteEnvironment((IoEnvironment)((Object)doc.getAdapter(IoEnvironment.class)));
            }
        }
    }
}

