/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.listener;

import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.io.LimitReachedException;

public class LimitEnvironmentListener
implements EventListener {
    private static final String QUERY_FIELD = "COUNT(ecm:uuid)";
    private static final String QUERY_ENVS = "Select COUNT(ecm:uuid) from ioEnvironment where ecm:parentId = '%s' AND ecm:currentLifeCycleState <> 'deleted' AND ecm:isProxy = 0";

    public void handleEvent(Event event) throws ClientException {
        DocumentModel envsRef;
        if (!"aboutToCreate".equals(event.getName())) {
            return;
        }
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentModel doc = ((DocumentEventContext)ctx).getSourceDocument();
        if (!doc.getType().equals("ioEnvironment")) {
            return;
        }
        CoreSession session = ctx.getCoreSession();
        DocumentModel client = session.getParentDocument((envsRef = session.getDocument(doc.getParentRef())).getRef());
        if (client == null) {
            return;
        }
        long clientLimit = (Long)client.getPropertyValue("ioclient:envLimit");
        long envsCount = this.countEnvironments(session, envsRef.getRef());
        if (envsCount >= clientLimit) {
            event.markBubbleException();
            throw new LimitReachedException(String.format("You reached your environments limit (%d).", clientLimit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long countEnvironments(CoreSession session, DocumentRef parentRef) throws ClientException {
        try (IterableQueryResult iqr = null;){
            String query = String.format(QUERY_ENVS, parentRef.toString());
            iqr = session.queryAndFetch(query, "NXQL", new Object[0]);
            Map next = (Map)iqr.iterator().next();
            long l = (Long)next.get(QUERY_FIELD);
            return l;
        }
    }
}

