/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.operation;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.io.service.IoService;

@Operation(id="Io.CreateClient", category="Io", label="Create an Io Client", description="Create a new Client for a dedicated user.")
public class CreateIoClient {
    public static final String ID = "Io.CreateClient";
    public static final String ENV_REGEX = "[^a-z0-9\\-]";
    @Context
    protected CoreSession session;
    @Context
    protected IoService ioService;
    @Context
    protected UserManager usrMg;
    @Param(name="clientName")
    protected String clientName;
    @Param(name="username")
    protected String username;
    @Param(name="email", required=false)
    protected String email;
    @Param(name="projectName", required=false)
    protected String projectName;
    @Param(name="createEnvironment", required=false)
    protected boolean createEnvironment = false;

    @OperationMethod
    public DocumentModel run() throws ClientException {
        final String[] docId = new String[1];
        this.createUserIfNeeded();
        new UnrestrictedSessionRunner(this.session.getRepositoryName(), this.username){

            public void run() throws ClientException {
                DocumentModel client = CreateIoClient.this.createClient(this.session);
                docId[0] = client.getId();
                if (CreateIoClient.this.createEnvironment) {
                    CreateIoClient.this.createEnvironment(this.session, client);
                }
            }
        }.runUnrestricted();
        return this.session.getDocument((DocumentRef)new IdRef(docId[0]));
    }

    protected void createUserIfNeeded() throws ClientException {
        DocumentModel user = this.usrMg.getUserModel(this.username);
        if (user == null) {
            user = this.usrMg.getBareUserModel();
            user.setPropertyValue(this.usrMg.getUserIdField(), (Serializable)((Object)this.username));
            user.setPropertyValue("user:company", (Serializable)((Object)this.clientName));
            user.setPropertyValue("user:email", (Serializable)((Object)this.email));
            user = this.usrMg.createUser(user);
            assert (StringUtils.isNotBlank((String)user.getId()));
        }
    }

    protected DocumentModel createClient(CoreSession session) throws ClientException {
        DocumentModel doc = session.createDocumentModel("/io/clients", this.clientName, "ioClient");
        doc.setPropertyValue("dc:title", (Serializable)((Object)this.clientName));
        doc = session.createDocument(doc);
        ACE ace = new ACE(this.username, "ReadWrite", true);
        ACP acp = doc.getACP();
        acp.getOrCreateACL("local").add((Object)ace);
        session.setACP(doc.getRef(), acp, true);
        return doc;
    }

    protected void createEnvironment(CoreSession session, DocumentModel client) throws ClientException {
        String envName = this.projectName;
        if (StringUtils.isBlank((String)envName)) {
            envName = this.username;
        }
        envName = envName.toLowerCase().replaceAll(ENV_REGEX, "");
        DocumentModel environment = session.createDocumentModel(String.format("/io/clients/%s/environments", client.getName()), envName, "ioEnvironment");
        environment.setPropertyValue("dc:title", (Serializable)((Object)envName));
        session.createDocument(environment);
    }
}

