/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.operation;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.io.adapter.IoClient;
import org.nuxeo.io.adapter.IoUser;
import org.nuxeo.io.service.IoService;

@Operation(id="Io.GetUser", category="Io", label="Get the current logged in user information", description="Get the current logged in user information. Return the list of associated clients")
public class GetIoUser {
    public static final String ID = "Io.GetUser";
    @Context
    protected CoreSession session;
    @Context
    protected IoService ioService;

    @OperationMethod
    public IoUser run() throws Exception {
        try {
            NuxeoPrincipal currentUser = (NuxeoPrincipal)this.session.getPrincipal();
            DocumentModelList clients = this.session.query(String.format("SELECT * FROM Document WHERE ecm:primaryType = '%s' AND ecm:currentLifeCycleState != 'deleted'", "ioClient"));
            return new IoUser(currentUser, GetIoUser.toIoClients((List<DocumentModel>)clients), this.ioService.getAvailableConnectProjects());
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    protected static List<IoClient> toIoClients(List<DocumentModel> clients) {
        ArrayList<IoClient> ioClients = new ArrayList<IoClient>();
        for (DocumentModel client : clients) {
            ioClients.add((IoClient)client.getAdapter(IoClient.class));
        }
        return ioClients;
    }
}

