/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.service;

import java.util.Arrays;
import java.util.List;

public class EnvironmentStatusComputer {
    public static final String STARTING_STATUS = "starting";
    public static final String STARTED_STATUS = "started";
    public static final String STOPPING_STATUS = "stopping";
    public static final String STOPPED_STATUS = "stopped";
    public static final String PASSIVATED_STATUS = "passivated";
    public static final String ERROR_STATUS = "error";
    public static final String NA_STATUS = "n/a";
    public static final List<String> EXPECTED_STATUSES = Arrays.asList("started", "stopped", "passivated");
    public static final List<String> CURRENT_STATUSES = Arrays.asList("starting", "started", "stopping", "stopped");
    protected final String expectedStatus;
    protected final String currentStatus;
    protected final String alive;

    public EnvironmentStatusComputer(String expectedStatus, String currentStatus, String alive) {
        this.expectedStatus = expectedStatus;
        this.currentStatus = currentStatus;
        this.alive = alive;
    }

    public String computeStatus() {
        String status;
        if (!EXPECTED_STATUSES.contains(this.expectedStatus) || !CURRENT_STATUSES.contains(this.currentStatus)) {
            status = NA_STATUS;
        } else {
            switch (this.currentStatus) {
                case "stopped": {
                    if (!this.expectedStatus.equals(PASSIVATED_STATUS)) {
                        status = this.expectedStatus.equals(STOPPED_STATUS) ? STOPPED_STATUS : ERROR_STATUS;
                        break;
                    }
                    status = PASSIVATED_STATUS;
                    break;
                }
                case "starting": {
                    status = this.expectedStatus.equals(STARTED_STATUS) ? STARTING_STATUS : ERROR_STATUS;
                    break;
                }
                case "started": {
                    if (this.alive != null) {
                        status = this.expectedStatus.equals(STARTED_STATUS) ? STARTED_STATUS : ERROR_STATUS;
                        break;
                    }
                    status = ERROR_STATUS;
                    break;
                }
                case "stopping": {
                    status = this.expectedStatus.equals(STOPPED_STATUS) ? STOPPING_STATUS : ERROR_STATUS;
                    break;
                }
                default: {
                    status = NA_STATUS;
                }
            }
        }
        return status;
    }
}

