/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.service;

import com.sun.jersey.api.client.WebResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.etcd.EtcdService;
import org.nuxeo.io.adapter.IoEnvironment;
import org.nuxeo.io.adapter.IoEnvironmentStatus;
import org.nuxeo.io.connect.InstanceRegistrator;
import org.nuxeo.io.connect.IoConnectClient;
import org.nuxeo.io.service.EnvironmentStatusComputer;
import org.nuxeo.io.service.IoService;
import org.nuxeo.io.service.Statuses;
import org.nuxeo.runtime.api.Framework;

public class IoServiceImpl
implements IoService {
    private static final int _1 = 1;
    private static final Log log = LogFactory.getLog(IoServiceImpl.class);
    public static final String ETCD_ENDPOINT_PROPERTY_NAME = "org.nuxeo.io.etcd.endpoint";
    private static final String CONTAINER_UNIT_NAME = "nxio.%s.%d.service";
    private static final String CLEANER_UNIT_NAME = "cleaner.%s.service";
    public static final String CREATE_ENV_COMMAND = "createEnvironment";
    public static final String DELETE_ENV_COMMAND = "deleteEnvironment";
    public static final String START_ENV_COMMAND = "startEnvironment";
    public static final String STOP_ENV_COMMAND = "stopEnvironment";
    public static final String START_CLEANER_COMMAND = "startCleaner";
    public static final String FLEET_CONTAINER_UNIT_TEMPLATE = "fleet_container_unit_template.service";
    public static final String FLEET_CLEANER_UNIT_TEMPLATE = "fleet_cleaner_unit_template.service";
    public static final String IO_CONTAINER_TYPE = "service";
    public static final String DOMAIN_KEY_PATTERN = "/domains/%s";
    public static final String DOMAIN_TYPE_KEY_PATTERN = "/domains/%s/type";
    public static final String DOMAIN_VALUE_KEY_PATTERN = "/domains/%s/value";
    public static final String SERVICE_KEY_PATTERN = "/services/%s/";
    public static final String SERVICE_DOMAIN_KEY_PATTERN = "/services/%s//%d/domain";
    public static final String SERVICE_STATUS_KEY_PATTERN = "/services/%s//%d/status";
    public static final String SERVICE_CURRENT_STATUS_KEY_PATTERN = "/services/%s//%d/status/current";
    public static final String SERVICE_CONFIG_KEY_PATTERN = "/services/%s//%d/config";
    public static final String SERVICE_CONFIG_PACKAGES = "/services/%s//%d/config/packages";
    public static final String SERVICE_CONFIG_CLIDS = "/services/%s//%d/config/instance.clid";
    public static final String SERVICE_EXPECTED_STATUS_KEY_PATTERN = "/services/%s//%d/status/expected";
    public static final String SERVICE_ALIVE_STATUS_KEY_PATTERN = "/services/%s//%d/status/alive";
    public static final String SERVICES_TO_CLEAN = "postgres s3 etcd";
    protected String fleetContainerUnitTemplate;
    protected String fleetCleanerUnitTemplate;

    @Override
    public void createEnvironment(IoEnvironment environment) {
        try {
            String unitTemplate = this.getFleetContainerUnitTemplate();
            String techId = environment.getTechId();
            unitTemplate = unitTemplate.replaceAll("\\$\\{envTechId\\}", techId);
            String unitName = String.format(CONTAINER_UNIT_NAME, techId, 1);
            File file = new File(this.getTempWorkingDirectory(), unitName);
            file.deleteOnExit();
            Framework.trackFile((File)file, (Object)this);
            FileUtils.writeStringToFile((File)file, (String)unitTemplate);
            CmdParameters parameters = new CmdParameters();
            parameters.addNamedParameter("unitFilePath", file);
            parameters.addNamedParameter("etcdEndpoint", Framework.getProperty((String)ETCD_ENDPOINT_PROPERTY_NAME));
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            cles.execCommand(CREATE_ENV_COMMAND, parameters);
        }
        catch (IOException | CommandNotAvailable e) {
            log.error((Object)"Cannot create environment", e);
        }
        List<ConnectProject> projects = this.getAvailableConnectProjects();
        if (projects.size() > 0) {
            environment.setApplication(projects.get(0).getUuid());
        }
        this.createEtcdKeysFor(environment);
        this.setCurrentStatus(environment, Statuses.STOPPED);
        this.setExpectedStatus(environment, Statuses.STOPPED);
    }

    protected String getFleetContainerUnitTemplate() {
        if (this.fleetContainerUnitTemplate == null) {
            this.fleetContainerUnitTemplate = this.getFleetUnitTemplate(FLEET_CONTAINER_UNIT_TEMPLATE);
        }
        return this.fleetContainerUnitTemplate;
    }

    protected String getFleetCleanerUnitTemplate() {
        if (this.fleetCleanerUnitTemplate == null) {
            this.fleetCleanerUnitTemplate = this.getFleetUnitTemplate(FLEET_CLEANER_UNIT_TEMPLATE);
        }
        return this.fleetCleanerUnitTemplate;
    }

    protected String getFleetUnitTemplate(String name) {
        String template = null;
        try {
            URL fileUrl = Thread.currentThread().getContextClassLoader().getResource(name);
            if (fileUrl != null) {
                template = IOUtils.toString((InputStream)fileUrl.openStream());
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        return template;
    }

    protected String getCLIDsEntry(IoEnvironment environment) {
        LogicalInstanceIdentifier CLIDs = new InstanceRegistrator(environment.getApplication(), environment.getName(), NuxeoClientInstanceType.DEV).getCLIDs();
        if (CLIDs != null) {
            return String.format("%s\\n%s\\n%s", CLIDs.getCLID1(), CLIDs.getCLID2(), CLIDs.getInstanceDescription());
        }
        return null;
    }

    protected File getTempWorkingDirectory() {
        File workingDir = new File(System.getProperty("java.io.tmpdir"), "nxio");
        if (!workingDir.exists()) {
            workingDir.mkdir();
        }
        return workingDir;
    }

    protected void createEtcdKeysFor(IoEnvironment environment) {
        EtcdService etcdService = (EtcdService)Framework.getLocalService(EtcdService.class);
        String domain = environment.getDomain();
        String techId = environment.getTechId();
        String typeKey = String.format(DOMAIN_TYPE_KEY_PATTERN, domain);
        String valueKey = String.format(DOMAIN_VALUE_KEY_PATTERN, domain);
        String domainKey = String.format(SERVICE_DOMAIN_KEY_PATTERN, techId, 1);
        String clidsKey = String.format(SERVICE_CONFIG_CLIDS, techId, 1);
        etcdService.set(typeKey, IO_CONTAINER_TYPE);
        etcdService.set(valueKey, techId);
        etcdService.set(domainKey, domain);
        etcdService.set(clidsKey, this.getCLIDsEntry(environment));
    }

    protected void setCurrentStatus(IoEnvironment environment, Statuses status) {
        EtcdService etcdService = (EtcdService)Framework.getLocalService(EtcdService.class);
        String currentStatusKey = IoServiceImpl.getCurrentStatusKeyFor(environment, 1);
        etcdService.set(currentStatusKey, status.toString());
    }

    protected void setExpectedStatus(IoEnvironment environment, Statuses status) {
        EtcdService etcdService = (EtcdService)Framework.getLocalService(EtcdService.class);
        String expectedStatusKey = IoServiceImpl.getExpectedStatusKeyFor(environment, 1);
        etcdService.set(expectedStatusKey, status.toString());
    }

    @Override
    public void deleteEnvironment(IoEnvironment environment) {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
        try {
            CmdParameters parameters = this.computeUnitNameCmdParameters(environment);
            cles.execCommand(DELETE_ENV_COMMAND, parameters);
        }
        catch (CommandNotAvailable e) {
            log.error((Object)e, (Throwable)e);
        }
        try {
            String techId = environment.getTechId();
            String unitName = String.format(CLEANER_UNIT_NAME, techId);
            String unitTemplate = this.getFleetCleanerUnitTemplate();
            unitTemplate = unitTemplate.replaceAll("\\$\\{envTechId\\}", techId);
            unitTemplate = unitTemplate.replaceAll("\\$\\{unitName\\}", unitName);
            unitTemplate = unitTemplate.replaceAll("\\$\\{services\\}", SERVICES_TO_CLEAN);
            File file = new File(this.getTempWorkingDirectory(), unitName);
            file.deleteOnExit();
            Framework.trackFile((File)file, (Object)this);
            FileUtils.writeStringToFile((File)file, (String)unitTemplate);
            CmdParameters parameters = new CmdParameters();
            parameters.addNamedParameter("unitFilePath", file);
            parameters.addNamedParameter("etcdEndpoint", Framework.getProperty((String)ETCD_ENDPOINT_PROPERTY_NAME));
            cles.execCommand(START_CLEANER_COMMAND, parameters);
        }
        catch (IOException | CommandNotAvailable e) {
            log.error((Object)"Cannot delete environment", e);
        }
    }

    protected CmdParameters computeUnitNameCmdParameters(IoEnvironment environment) {
        String techId = environment.getTechId();
        String unitName = String.format(CONTAINER_UNIT_NAME, techId, 1);
        CmdParameters parameters = new CmdParameters();
        parameters.addNamedParameter("unitName", unitName);
        parameters.addNamedParameter("etcdEndpoint", Framework.getProperty((String)ETCD_ENDPOINT_PROPERTY_NAME));
        return parameters;
    }

    protected void deleteServiceEtcdKeyFor(IoEnvironment environment) {
        EtcdService etcdService = (EtcdService)Framework.getLocalService(EtcdService.class);
        String techId = environment.getTechId();
        String serviceKey = String.format(SERVICE_KEY_PATTERN, techId);
        etcdService.delete(serviceKey, true);
    }

    @Override
    public void startEnvironment(IoEnvironment environment) {
        try {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            CmdParameters parameters = this.computeUnitNameCmdParameters(environment);
            cles.execCommand(STOP_ENV_COMMAND, parameters);
            this.setExpectedStatus(environment, Statuses.STARTED);
            cles.execCommand(START_ENV_COMMAND, parameters);
        }
        catch (CommandNotAvailable e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void stopEnvironment(IoEnvironment environment) {
        try {
            this.setExpectedStatus(environment, Statuses.STOPPED);
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            CmdParameters parameters = this.computeUnitNameCmdParameters(environment);
            cles.execCommand(STOP_ENV_COMMAND, parameters);
        }
        catch (CommandNotAvailable e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void updateEnvironment(IoEnvironment oldEnvironment, IoEnvironment newEnvironment) {
        EtcdService etcdService = (EtcdService)Framework.getLocalService(EtcdService.class);
        String oldDomain = oldEnvironment.getDomain();
        String oldApplication = oldEnvironment.getApplication();
        String newDomain = newEnvironment.getDomain();
        String newApplication = newEnvironment.getApplication();
        String techId = newEnvironment.getTechId();
        if (!oldDomain.equals(newDomain)) {
            String typeKey = String.format(DOMAIN_TYPE_KEY_PATTERN, newDomain);
            String valueKey = String.format(DOMAIN_VALUE_KEY_PATTERN, newDomain);
            etcdService.set(typeKey, IO_CONTAINER_TYPE);
            etcdService.set(valueKey, techId);
            String domainKey = String.format(SERVICE_DOMAIN_KEY_PATTERN, techId, 1);
            etcdService.set(domainKey, newDomain);
            this.deleteDomainEtcdKeyFor(oldEnvironment);
        }
        if (oldApplication == null || !oldApplication.equals(newApplication)) {
            String clidsKey = String.format(SERVICE_CONFIG_CLIDS, techId, 1);
            etcdService.set(clidsKey, this.getCLIDsEntry(newEnvironment));
        }
    }

    protected void deleteDomainEtcdKeyFor(IoEnvironment environment) {
        EtcdService etcdService = (EtcdService)Framework.getLocalService(EtcdService.class);
        String oldDomain = environment.getDomain();
        String key = String.format(DOMAIN_KEY_PATTERN, oldDomain);
        etcdService.delete(key, true);
    }

    @Override
    public IoEnvironmentStatus getEnvironmentStatus(IoEnvironment environment) {
        EtcdService etcdService = (EtcdService)Framework.getLocalService(EtcdService.class);
        String currentStatus = etcdService.getValue(IoServiceImpl.getCurrentStatusKeyFor(environment, 1));
        String expectedStatus = etcdService.getValue(IoServiceImpl.getExpectedStatusKeyFor(environment, 1));
        String alive = etcdService.getValue(IoServiceImpl.getAliveStatusKeyFor(environment, 1));
        EnvironmentStatusComputer computer = new EnvironmentStatusComputer(expectedStatus, currentStatus, alive);
        String environmentStatus = computer.computeStatus();
        return new IoEnvironmentStatus(environment.getDocument(), environmentStatus);
    }

    @Override
    public List<ConnectProject> getAvailableConnectProjects() {
        if (Framework.isTestModeSet()) {
            return Collections.emptyList();
        }
        WebResource r = IoConnectClient.resource(ConnectUrlConfig.getRegistrationBaseUrl() + "getAvailableProjectsForRegistration");
        ArrayList<ConnectProject> result = new ArrayList<ConnectProject>();
        try {
            JSONArray array = new JSONArray((String)r.get(String.class));
            for (int i = 0; i < array.length(); ++i) {
                JSONObject ob = (JSONObject)array.get(i);
                result.add((ConnectProject)AbstractJSONSerializableData.loadFromJSON(ConnectProject.class, (JSONObject)ob));
            }
        }
        catch (JSONException e) {
            log.debug((Object)e, (Throwable)e);
        }
        return result;
    }

    public static String getCurrentStatusKeyFor(IoEnvironment env, int index) {
        return String.format(SERVICE_CURRENT_STATUS_KEY_PATTERN, env.getTechId(), index);
    }

    public static String getExpectedStatusKeyFor(IoEnvironment env, int index) {
        return String.format(SERVICE_EXPECTED_STATUS_KEY_PATTERN, env.getTechId(), index);
    }

    public static String getAliveStatusKeyFor(IoEnvironment env, int index) {
        return String.format(SERVICE_ALIVE_STATUS_KEY_PATTERN, env.getTechId(), index);
    }

    public static String getNXDomainKeyFor(IoEnvironment env, int index) {
        return String.format(SERVICE_DOMAIN_KEY_PATTERN, env.getTechId(), index);
    }
}

