/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProvider;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProviderDescriptor;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProviderRegistry;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDProviderFragmentRegistry;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.ecm.platform.ui.web.auth.LoginScreenHelper;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLinkComputer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class OpenIDConnectProviderRegistryImpl
extends DefaultComponent
implements OpenIDConnectProviderRegistry {
    protected static final Log log = LogFactory.getLog(OpenIDConnectProviderRegistryImpl.class);
    public static final String PROVIDER_EP = "providers";
    protected Map<String, OpenIDConnectProvider> providers = new HashMap<String, OpenIDConnectProvider>();
    protected OpenIDProviderFragmentRegistry pendingProviders = new OpenIDProviderFragmentRegistry();

    protected OAuth2ServiceProviderRegistry getOAuth2ServiceProviderRegistry() {
        return (OAuth2ServiceProviderRegistry)Framework.getLocalService(OAuth2ServiceProviderRegistry.class);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PROVIDER_EP.equals(extensionPoint)) {
            OpenIDConnectProviderDescriptor provider = (OpenIDConnectProviderDescriptor)contribution;
            if (provider.getClientId() == null || provider.getClientSecret() == null) {
                log.info((Object)("OpenId provider for " + provider.getName() + " is disabled because clientId and/or clientSecret are empty (component id = " + contributor.getName().toString() + ")"));
                provider.setEnabled(false);
            }
            log.info((Object)("OpenId provider for " + provider.getName() + " will be registred at application startup"));
            this.pendingProviders.addContribution(provider);
        }
    }

    @Override
    public Collection<OpenIDConnectProvider> getProviders() {
        return this.providers.values();
    }

    @Override
    public Collection<OpenIDConnectProvider> getEnabledProviders() {
        ArrayList<OpenIDConnectProvider> result = new ArrayList<OpenIDConnectProvider>();
        for (OpenIDConnectProvider provider : this.getProviders()) {
            if (!provider.isEnabled()) continue;
            result.add(provider);
        }
        return result;
    }

    @Override
    public OpenIDConnectProvider getProvider(String name) {
        return this.providers.get(name);
    }

    protected void registerPendingProviders() throws Exception {
        for (OpenIDConnectProviderDescriptor provider : this.pendingProviders.getContribs()) {
            this.registerOpenIdProvider(provider);
        }
    }

    protected void registerOpenIdProvider(OpenIDConnectProviderDescriptor provider) throws Exception {
        OAuth2ServiceProviderRegistry oauth2ProviderRegistry = this.getOAuth2ServiceProviderRegistry();
        if (oauth2ProviderRegistry != null) {
            NuxeoOAuth2ServiceProvider oauth2Provider = oauth2ProviderRegistry.getProvider(provider.getName());
            if (oauth2Provider == null) {
                oauth2Provider = oauth2ProviderRegistry.addProvider(provider.getName(), provider.getTokenServerURL(), provider.getAuthorizationServerURL(), provider.getClientId(), provider.getClientSecret(), Arrays.asList(provider.getScopes()));
            } else {
                log.warn((Object)("Provider " + provider.getName() + " is already in the Database, XML contribution  won't overwrite it"));
            }
            this.providers.put(provider.getName(), new OpenIDConnectProvider(oauth2Provider, provider.getAccessTokenKey(), provider.getUserInfoURL(), provider.getUserInfoClass(), provider.getIcon(), provider.isEnabled(), provider.getRedirectUriResolver().newInstance(), provider.getUserResolverClass()));
            LoginScreenHelper.registerLoginProvider((String)provider.getName(), (String)provider.getIcon(), (String)provider.getUserInfoURL(), (String)provider.getLabel(), (String)provider.getDescription(), (LoginProviderLinkComputer)this.providers.get(provider.getName()));
        } else if (Framework.isTestModeSet()) {
            this.providers.put(provider.getName(), new OpenIDConnectProvider(null, provider.getAccessTokenKey(), provider.getUserInfoURL(), provider.getUserInfoClass(), provider.getIcon(), provider.isEnabled(), provider.getRedirectUriResolver().newInstance(), provider.getUserResolverClass()));
        } else {
            log.error((Object)"Can not register OAuth Provider since OAuth Registry is not available");
        }
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        super.applicationStarted(context);
        this.registerPendingProviders();
    }
}

