/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProviderDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class OpenIDProviderFragmentRegistry
extends ContributionFragmentRegistry<OpenIDConnectProviderDescriptor> {
    protected final Map<String, OpenIDConnectProviderDescriptor> providers = new HashMap<String, OpenIDConnectProviderDescriptor>();

    public OpenIDConnectProviderDescriptor clone(OpenIDConnectProviderDescriptor source) {
        OpenIDConnectProviderDescriptor copy = new OpenIDConnectProviderDescriptor();
        copy.scopes = source.scopes;
        copy.authorizationServerURL = source.authorizationServerURL;
        copy.clientId = source.clientId;
        copy.clientSecret = source.clientSecret;
        copy.icon = source.icon;
        copy.enabled = source.enabled;
        copy.name = source.name;
        copy.tokenServerURL = source.tokenServerURL;
        copy.userInfoURL = source.userInfoURL;
        copy.label = source.label;
        copy.description = source.description;
        copy.redirectUriResolver = source.redirectUriResolver;
        copy.userResolverClass = source.userResolverClass;
        copy.accessTokenKey = source.accessTokenKey;
        copy.userInfoClass = source.userInfoClass;
        return copy;
    }

    public void contributionRemoved(String name, OpenIDConnectProviderDescriptor origContrib) {
        this.providers.remove(name);
    }

    public void contributionUpdated(String name, OpenIDConnectProviderDescriptor contrib, OpenIDConnectProviderDescriptor newOrigContrib) {
        if (contrib.isEnabled()) {
            this.providers.put(name, contrib);
        } else {
            this.providers.remove(name);
        }
    }

    public String getContributionId(OpenIDConnectProviderDescriptor contrib) {
        return contrib.getName();
    }

    public void merge(OpenIDConnectProviderDescriptor src, OpenIDConnectProviderDescriptor dst) {
        if (dst.authorizationServerURL == null || dst.authorizationServerURL.isEmpty()) {
            dst.authorizationServerURL = src.authorizationServerURL;
        }
        if (dst.clientId == null || dst.clientId.isEmpty()) {
            dst.clientId = src.clientId;
        }
        if (dst.clientSecret == null || dst.clientSecret.isEmpty()) {
            dst.clientSecret = src.clientSecret;
        }
        if (dst.icon == null || dst.icon.isEmpty()) {
            dst.icon = src.icon;
        }
        if (dst.scopes == null || dst.scopes.length == 0) {
            dst.scopes = src.scopes;
        }
        if (dst.tokenServerURL == null || dst.tokenServerURL.isEmpty()) {
            dst.tokenServerURL = src.tokenServerURL;
        }
        if (dst.userInfoURL == null || dst.userInfoURL.isEmpty()) {
            dst.userInfoURL = src.userInfoURL;
        }
        if (dst.label == null || dst.label.isEmpty()) {
            dst.label = src.label;
        }
        if (dst.description == null || dst.description.isEmpty()) {
            dst.description = src.description;
        }
        if (!src.accessTokenKey.equals("access_token")) {
            dst.accessTokenKey = src.accessTokenKey;
        }
        if (src.userInfoClass != OpenIDConnectProviderDescriptor.DEFAULT_USER_INFO_CLASS) {
            dst.userInfoClass = src.userInfoClass;
        }
        if (src.redirectUriResolver != OpenIDConnectProviderDescriptor.DEFAULT_REDIRECT_URI_RESOLVER_CLASS) {
            dst.redirectUriResolver = src.redirectUriResolver;
        }
        if (src.userResolverClass != OpenIDConnectProviderDescriptor.DEFAULT_USER_RESOLVER_CLASS) {
            dst.userResolverClass = src.userResolverClass;
        }
        dst.accessTokenKey = src.accessTokenKey;
        dst.userInfoClass = src.userInfoClass;
        dst.redirectUriResolver = src.redirectUriResolver;
        dst.userResolverClass = src.userResolverClass;
        dst.enabled = src.enabled;
    }

    public Collection<OpenIDConnectProviderDescriptor> getContribs() {
        return this.providers.values();
    }
}

