/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProvider;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProviderRegistry;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfo;
import org.nuxeo.ecm.platform.oauth2.openid.auth.UserResolver;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.runtime.api.Framework;

public class OpenIDConnectAuthenticator
implements NuxeoAuthenticationPlugin {
    private static final Log log = LogFactory.getLog(OpenIDConnectAuthenticator.class);
    public static final String STATE_URL_PARAM_NAME = "state";
    public static final String STATE_SESSION_ATTRIBUTE = "state";
    public static final String CODE_URL_PARAM_NAME = "code";
    public static final String ERROR_URL_PARAM_NAME = "error";
    public static final String PROVIDER_URL_PARAM_NAME = "provider";
    public static final String USERINFO_KEY = "OPENID_USERINFO";

    protected void sendError(HttpServletRequest req, String msg) {
        req.setAttribute("org.nuxeo.ecm.login.error", (Object)msg);
    }

    public UserIdentificationInfo retrieveIdentityFromOAuth(HttpServletRequest req, HttpServletResponse resp) {
        String error = req.getParameter(ERROR_URL_PARAM_NAME);
        if (error != null && error.length() > 0) {
            this.sendError(req, "There was an error: \"" + error + "\".");
            return null;
        }
        String code = req.getParameter(CODE_URL_PARAM_NAME);
        if (code == null || code.isEmpty()) {
            this.sendError(req, "There was an error: \"" + code + "\".");
            return null;
        }
        String serviceProviderName = req.getParameter(PROVIDER_URL_PARAM_NAME);
        if (serviceProviderName == null || serviceProviderName.isEmpty()) {
            this.sendError(req, "Missing OpenID Connect Provider ID.");
            return null;
        }
        try {
            String accessToken;
            OpenIDConnectProviderRegistry registry = (OpenIDConnectProviderRegistry)Framework.getLocalService(OpenIDConnectProviderRegistry.class);
            OpenIDConnectProvider provider = registry.getProvider(serviceProviderName);
            if (provider == null) {
                this.sendError(req, "No service provider called: \"" + serviceProviderName + "\".");
                return null;
            }
            if (!"true".equals(Framework.getProperty((String)"nuxeo.skip.oauth.token.state.check")) && !provider.verifyStateToken(req)) {
                this.sendError(req, "Invalid state parameter.");
            }
            if ((accessToken = provider.getAccessToken(req, code)) == null) {
                return null;
            }
            OpenIDUserInfo info = provider.getUserInfo(accessToken);
            req.setAttribute(USERINFO_KEY, (Object)info);
            UserResolver userResolver = provider.getUserResolver();
            String userId = userResolver.findNuxeoUser(info);
            if (userId == null) {
                this.sendError(req, "No user found with email: \"" + info.getEmail() + "\".");
                return null;
            }
            return new UserIdentificationInfo(userId, userId);
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieve Identity From OAuth", (Throwable)e);
            return null;
        }
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return new ArrayList<String>();
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String error = httpRequest.getParameter(ERROR_URL_PARAM_NAME);
        String code = httpRequest.getParameter(CODE_URL_PARAM_NAME);
        String serviceProviderName = httpRequest.getParameter(PROVIDER_URL_PARAM_NAME);
        if (serviceProviderName == null) {
            return null;
        }
        if (code == null && error == null) {
            return null;
        }
        UserIdentificationInfo userIdent = this.retrieveIdentityFromOAuth(httpRequest, httpResponse);
        if (userIdent != null) {
            userIdent.setAuthPluginName("TRUSTED_LM");
        }
        return userIdent;
    }

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        return false;
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return false;
    }

    public void initPlugin(Map<String, String> parameters) {
    }
}

