/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid.auth;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.openid.auth.DefaultOpenIDUserInfo;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfo;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfoStore;
import org.nuxeo.runtime.api.Framework;

public class OpenIDUserInfoStoreImpl
implements OpenIDUserInfoStore {
    protected static final Log log = LogFactory.getLog(OpenIDUserInfoStoreImpl.class);
    public static final String DIRECTORY_NAME = "openIdUserInfos";
    public static final String SCHEMA_NAME = "openIdUserInfo";
    public static final String NUXEO_LOGIN_KEY = "nuxeoLogin";
    public static final String OPENID_SUBJECT_KEY = "subject";
    public static final String OPENID_PROVIDER_KEY = "provider";
    public static final String ID = "id";
    private String providerName;

    public OpenIDUserInfoStoreImpl(String providerName) {
        this.providerName = providerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeUserInfo(String userId, OpenIDUserInfo userInfo) {
        Session session = null;
        try {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            session = ds.open(DIRECTORY_NAME);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(ID, this.getID(this.providerName, userInfo.getSubject()));
            data.put(NUXEO_LOGIN_KEY, userId);
            data.put(OPENID_PROVIDER_KEY, this.providerName);
            data.put(OPENID_SUBJECT_KEY, userInfo.getSubject());
            data.put("name", userInfo.getName());
            data.put("given_name", userInfo.getGivenName());
            data.put("family_name", userInfo.getFamilyName());
            data.put("middle_name", userInfo.getMiddleName());
            data.put("nickname", userInfo.getNickname());
            data.put("preferred_username", userInfo.getPreferredUsername());
            data.put("profile", userInfo.getProfile());
            data.put("picture", userInfo.getPicture());
            data.put("website", userInfo.getWebsite());
            data.put("email", userInfo.getEmail());
            data.put("email_verified", userInfo.isEmailVerified());
            data.put("gender", userInfo.getGender());
            data.put("birthdate", userInfo.getBirthdate());
            data.put("zoneinfo", userInfo.getZoneInfo());
            data.put("locale", userInfo.getLocale());
            data.put("phone_number", userInfo.getPhoneNumber());
            data.put("address", userInfo.getAddress());
            data.put("updated_time", userInfo.getUpdatedTime());
            session.createEntry(data);
        }
        catch (Exception e) {
            log.error((Object)"Error during token storage", (Throwable)e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (DirectoryException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNuxeoLogin(OpenIDUserInfo userInfo) {
        String string;
        Session session = null;
        try {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            session = ds.open(DIRECTORY_NAME);
            DocumentModel entry = session.getEntry(this.getID(this.providerName, userInfo.getSubject()));
            if (entry == null) {
                String string2 = null;
                return string2;
            }
            string = (String)((Object)entry.getPropertyValue("openIdUserInfo:nuxeoLogin"));
        }
        catch (Exception e) {
            log.error((Object)"Error retrieving OpenID user info", (Throwable)e);
            String string3 = null;
            return string3;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (DirectoryException e) {}
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenIDUserInfo getUserInfo(String nuxeoLogin) {
        DefaultOpenIDUserInfo defaultOpenIDUserInfo;
        Session session = null;
        try {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            session = ds.open(DIRECTORY_NAME);
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put(OPENID_PROVIDER_KEY, this.providerName);
            filter.put(NUXEO_LOGIN_KEY, nuxeoLogin);
            DocumentModelList entries = session.query(filter);
            if (entries.size() == 0) {
                OpenIDUserInfo openIDUserInfo = null;
                return openIDUserInfo;
            }
            DocumentModel entry = (DocumentModel)entries.get(0);
            DefaultOpenIDUserInfo userInfo = new DefaultOpenIDUserInfo();
            userInfo.putAll(entry.getProperties(SCHEMA_NAME));
            defaultOpenIDUserInfo = userInfo;
        }
        catch (Exception e) {
            log.error((Object)"Error retrieving OpenID user info", (Throwable)e);
            OpenIDUserInfo openIDUserInfo = null;
            return openIDUserInfo;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (DirectoryException e) {}
            }
        }
        return defaultOpenIDUserInfo;
    }

    protected String getID(String provider, String subject) {
        return subject + "@" + provider;
    }
}

