/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid.auth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProvider;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfo;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfoStore;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfoStoreImpl;
import org.nuxeo.ecm.platform.oauth2.openid.auth.UserResolver;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class StoredUserInfoResolver
extends UserResolver {
    private OpenIDUserInfoStore userInfoStore;
    private static final Log log = LogFactory.getLog(StoredUserInfoResolver.class);

    public StoredUserInfoResolver(OpenIDConnectProvider provider) {
        super(provider);
    }

    public OpenIDUserInfoStore getUserInfoStore() {
        if (this.userInfoStore == null) {
            this.userInfoStore = new OpenIDUserInfoStoreImpl(this.getProvider().getName());
        }
        return this.userInfoStore;
    }

    @Override
    public String findNuxeoUser(OpenIDUserInfo userInfo) {
        String nuxeoLogin = this.getUserInfoStore().getNuxeoLogin(userInfo);
        try {
            UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
            if (userManager.getUserModel(nuxeoLogin) == null) {
                nuxeoLogin = null;
            }
        }
        catch (ClientException e) {
            log.error((Object)("Error while search user in UserManager using email " + userInfo.getEmail()), (Throwable)e);
            return null;
        }
        return nuxeoLogin;
    }

    @Override
    public DocumentModel updateUserInfo(DocumentModel user, OpenIDUserInfo userInfo) {
        try {
            UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
            String userId = (String)((Object)user.getPropertyValue(userManager.getUserIdField()));
            this.getUserInfoStore().storeUserInfo(userId, userInfo);
        }
        catch (ClientException e) {
            log.error((Object)("Error while updating user info for user " + userInfo.getEmail()), (Throwable)e);
            return null;
        }
        return user;
    }
}

