/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid.web;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoAuthenticationFilter;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class OAuth2CallbackHandlerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(OAuth2CallbackHandlerServlet.class);
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    public static final String CODE_URL_PARAM_NAME = "code";
    public static final String ERROR_URL_PARAM_NAME = "error";
    public static final String INSTALLED_APP_URL_PARAMETER = "app";
    public static final String INSTALLED_APP_USER_ID = "system";
    public static final String URL_MAPPING = "/openid";
    public static final String REDIRECT_URL = "/";

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String error = req.getParameter(ERROR_URL_PARAM_NAME);
        if (error != null && error.length() > 0) {
            resp.sendError(406, "There was an error: \"" + error + "\".");
            return;
        }
        String code = req.getParameter(CODE_URL_PARAM_NAME);
        if (code == null || code.isEmpty()) {
            resp.sendError(400, "There was an error: \"" + error + "\".");
            return;
        }
        String path = req.getRequestURI().split("/openid/")[1];
        String[] parts = path.split(REDIRECT_URL);
        String serviceProviderName = parts[0];
        try {
            NuxeoOAuth2ServiceProvider provider = OAuth2CallbackHandlerServlet.getServiceProvider(serviceProviderName);
            if (provider == null) {
                resp.sendError(404, "No service provider called: \"" + serviceProviderName + "\".");
                return;
            }
            AuthorizationCodeFlow flow = provider.getAuthorizationCodeFlow(HTTP_TRANSPORT, JSON_FACTORY);
            String redirectUri = req.getRequestURL().toString();
            HttpResponse response = flow.newTokenRequest(code).setRedirectUri(redirectUri).executeUnparsed();
            TokenResponse tokenResponse = (TokenResponse)response.parseAs(TokenResponse.class);
            String accessToken = tokenResponse.getAccessToken();
            HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

                public void initialize(HttpRequest request) throws IOException {
                    request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
                }
            });
            GenericUrl url = new GenericUrl("https://www.googleapis.com/oauth2/v1/tokeninfo");
            url.set("access_token", (Object)accessToken);
            HttpRequest request = requestFactory.buildGetRequest(url);
            response = request.execute();
            String email = "nelson.silva@gmail.com";
            UserManager manager = (UserManager)Framework.getLocalService(UserManager.class);
            HashMap<String, String> query = new HashMap<String, String>();
            query.put(manager.getUserEmailField(), email);
            DocumentModelList users = manager.searchUsers(query, null);
            if (users.isEmpty()) {
                resp.sendError(404, "No user found with email: \"" + email + "\".");
            }
            DocumentModel user = (DocumentModel)users.get(0);
            String userId = (String)((Object)user.getPropertyValue(manager.getUserIdField()));
            Framework.loginAs((String)userId);
            LoginContext loginContext = NuxeoAuthenticationFilter.loginAs((String)userId);
            loginContext.login();
            resp.sendRedirect(req.getContextPath());
        }
        catch (Exception e) {
            log.error((Object)"Error while processing OAuth2 Callback", (Throwable)e);
        }
    }

    protected static NuxeoOAuth2ServiceProvider getServiceProvider(String serviceName) throws Exception {
        OAuth2ServiceProviderRegistry registry = (OAuth2ServiceProviderRegistry)Framework.getLocalService(OAuth2ServiceProviderRegistry.class);
        NuxeoOAuth2ServiceProvider nuxeoServiceProvider = registry.getProvider(serviceName);
        return nuxeoServiceProvider;
    }
}

