/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import com.google.common.base.Objects;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.SizeUtils;
import org.nuxeo.ecm.core.storage.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerDescriptor;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerRootDescriptor;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerStatus;
import org.nuxeo.ecm.core.storage.binary.CachingBinaryManager;
import org.nuxeo.ecm.core.storage.binary.FileStorage;
import org.nuxeo.ecm.core.storage.sql.BasicAWSCredentialsProvider;
import org.nuxeo.runtime.api.Framework;

public class S3BinaryManager
extends CachingBinaryManager {
    private static final Log log = LogFactory.getLog(S3BinaryManager.class);
    public static final String BUCKET_NAME_KEY = "nuxeo.s3storage.bucket";
    public static final String BUCKET_PREFIX_KEY = "nuxeo.s3storage.bucket.prefix";
    public static final String BUCKET_REGION_KEY = "nuxeo.s3storage.region";
    public static final String DEFAULT_BUCKET_REGION = null;
    public static final String AWS_ID_KEY = "nuxeo.s3storage.awsid";
    public static final String AWS_ID_ENV_KEY = "AWS_ACCESS_KEY_ID";
    public static final String AWS_SECRET_KEY = "nuxeo.s3storage.awssecret";
    public static final String AWS_SECRET_ENV_KEY = "AWS_SECRET_ACCESS_KEY";
    public static final String CACHE_SIZE_KEY = "nuxeo.s3storage.cachesize";
    public static final String DEFAULT_CACHE_SIZE = "100 MB";
    public static final String CONNECTION_MAX_KEY = "nuxeo.s3storage.connection.max";
    public static final String CONNECTION_RETRY_KEY = "nuxeo.s3storage.connection.retry";
    public static final String CONNECTION_TIMEOUT_KEY = "nuxeo.s3storage.connection.timeout";
    public static final String SOCKET_TIMEOUT_KEY = "nuxeo.s3storage.socket.timeout";
    public static final String KEYSTORE_FILE_KEY = "nuxeo.s3storage.crypt.keystore.file";
    public static final String KEYSTORE_PASS_KEY = "nuxeo.s3storage.crypt.keystore.password";
    public static final String PRIVKEY_ALIAS_KEY = "nuxeo.s3storage.crypt.key.alias";
    public static final String PRIVKEY_PASS_KEY = "nuxeo.s3storage.crypt.key.password";
    public static final String ENDPOINT_KEY = "nuxeo.s3storage.endpoint";
    public static final String PROXY_HOST_KEY = "nuxeo.http.proxy.host";
    public static final String PROXY_PORT_KEY = "nuxeo.http.proxy.port";
    public static final String PROXY_LOGIN_KEY = "nuxeo.http.proxy.login";
    public static final String PROXY_PASSWORD_KEY = "nuxeo.http.proxy.password";
    private static final String MD5 = "MD5";
    private static final Pattern MD5_RE = Pattern.compile("(.*/)?[0-9a-f]{32}");
    protected String bucketName;
    protected String bucketNamePrefix;
    protected AWSCredentialsProvider awsCredentialsProvider;
    protected ClientConfiguration clientConfiguration;
    protected EncryptionMaterials encryptionMaterials;
    protected CryptoConfiguration cryptoConfiguration;
    protected String repositoryName;
    protected AmazonS3 amazonS3;

    public void initialize(BinaryManagerDescriptor binaryManagerDescriptor) throws IOException {
        this.repositoryName = binaryManagerDescriptor.repositoryName;
        this.descriptor = new BinaryManagerRootDescriptor();
        this.descriptor.digest = MD5;
        log.info((Object)("Repository '" + this.repositoryName + "' using " + ((Object)((Object)this)).getClass().getSimpleName()));
        this.bucketName = Framework.getProperty((String)BUCKET_NAME_KEY);
        this.bucketNamePrefix = (String)Objects.firstNonNull((Object)Framework.getProperty((String)BUCKET_PREFIX_KEY), (Object)"");
        String bucketRegion = Framework.getProperty((String)BUCKET_REGION_KEY);
        if (StringUtils.isBlank((String)bucketRegion)) {
            bucketRegion = DEFAULT_BUCKET_REGION;
        }
        String awsID = Framework.getProperty((String)AWS_ID_KEY);
        String awsSecret = Framework.getProperty((String)AWS_SECRET_KEY);
        String proxyHost = Framework.getProperty((String)PROXY_HOST_KEY);
        String proxyPort = Framework.getProperty((String)PROXY_PORT_KEY);
        String proxyLogin = Framework.getProperty((String)PROXY_LOGIN_KEY);
        String proxyPassword = Framework.getProperty((String)PROXY_PASSWORD_KEY);
        String cacheSizeStr = Framework.getProperty((String)CACHE_SIZE_KEY);
        if (StringUtils.isBlank((String)cacheSizeStr)) {
            cacheSizeStr = DEFAULT_CACHE_SIZE;
        }
        int maxConnections = S3BinaryManager.getIntProperty(CONNECTION_MAX_KEY);
        int maxErrorRetry = S3BinaryManager.getIntProperty(CONNECTION_RETRY_KEY);
        int connectionTimeout = S3BinaryManager.getIntProperty(CONNECTION_TIMEOUT_KEY);
        int socketTimeout = S3BinaryManager.getIntProperty(SOCKET_TIMEOUT_KEY);
        String keystoreFile = Framework.getProperty((String)KEYSTORE_FILE_KEY);
        String keystorePass = Framework.getProperty((String)KEYSTORE_PASS_KEY);
        String privkeyAlias = Framework.getProperty((String)PRIVKEY_ALIAS_KEY);
        String privkeyPass = Framework.getProperty((String)PRIVKEY_PASS_KEY);
        String endpoint = Framework.getProperty((String)ENDPOINT_KEY);
        if (StringUtils.isBlank((String)awsID)) {
            awsID = System.getenv(AWS_ID_ENV_KEY);
        }
        if (StringUtils.isBlank((String)awsSecret)) {
            awsSecret = System.getenv(AWS_SECRET_ENV_KEY);
        }
        if (StringUtils.isBlank((String)this.bucketName)) {
            throw new RuntimeException("Missing conf: nuxeo.s3storage.bucket");
        }
        if (!StringUtils.isBlank((String)this.bucketNamePrefix) && !this.bucketNamePrefix.endsWith("/")) {
            log.warn((Object)String.format("%s %s S3 bucket prefix should end by '/' : added automatically.", BUCKET_PREFIX_KEY, this.bucketNamePrefix));
            this.bucketNamePrefix = this.bucketNamePrefix + "/";
        }
        if (StringUtils.isBlank((String)awsID) || StringUtils.isBlank((String)awsSecret)) {
            this.awsCredentialsProvider = new InstanceProfileCredentialsProvider();
            try {
                this.awsCredentialsProvider.getCredentials();
            }
            catch (AmazonClientException e) {
                throw new RuntimeException("Missing AWS credentials and no instance role found");
            }
        } else {
            this.awsCredentialsProvider = new BasicAWSCredentialsProvider(awsID, awsSecret);
        }
        this.clientConfiguration = new ClientConfiguration();
        if (StringUtils.isNotBlank((String)proxyHost)) {
            this.clientConfiguration.setProxyHost(proxyHost);
        }
        if (StringUtils.isNotBlank((String)proxyPort)) {
            this.clientConfiguration.setProxyPort(Integer.parseInt(proxyPort));
        }
        if (StringUtils.isNotBlank((String)proxyLogin)) {
            this.clientConfiguration.setProxyUsername(proxyLogin);
        }
        if (proxyPassword != null) {
            this.clientConfiguration.setProxyPassword(proxyPassword);
        }
        if (maxConnections > 0) {
            this.clientConfiguration.setMaxConnections(maxConnections);
        }
        if (maxErrorRetry >= 0) {
            this.clientConfiguration.setMaxErrorRetry(maxErrorRetry);
        }
        if (connectionTimeout >= 0) {
            this.clientConfiguration.setConnectionTimeout(connectionTimeout);
        }
        if (socketTimeout >= 0) {
            this.clientConfiguration.setSocketTimeout(socketTimeout);
        }
        this.encryptionMaterials = null;
        if (StringUtils.isNotBlank((String)keystoreFile)) {
            boolean confok = true;
            if (keystorePass == null) {
                log.error((Object)"Keystore password missing");
                confok = false;
            }
            if (StringUtils.isBlank((String)privkeyAlias)) {
                log.error((Object)"Key alias missing");
                confok = false;
            }
            if (privkeyPass == null) {
                log.error((Object)"Key password missing");
                confok = false;
            }
            if (!confok) {
                throw new RuntimeException("S3 Crypto configuration incomplete");
            }
            try {
                File ksFile = new File(keystoreFile);
                FileInputStream ksStream = new FileInputStream(ksFile);
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(ksStream, keystorePass.toCharArray());
                ksStream.close();
                if (!keystore.isKeyEntry(privkeyAlias)) {
                    throw new RuntimeException("Alias " + privkeyAlias + " is missing or not a key alias");
                }
                PrivateKey privKey = (PrivateKey)keystore.getKey(privkeyAlias, privkeyPass.toCharArray());
                Certificate cert = keystore.getCertificate(privkeyAlias);
                PublicKey pubKey = cert.getPublicKey();
                KeyPair keypair = new KeyPair(pubKey, privKey);
                this.encryptionMaterials = new EncryptionMaterials(keypair);
                this.cryptoConfiguration = new CryptoConfiguration();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read keystore: " + keystoreFile + ", alias: " + privkeyAlias, e);
            }
        }
        this.amazonS3 = this.encryptionMaterials == null ? new AmazonS3Client(this.awsCredentialsProvider, this.clientConfiguration) : new AmazonS3EncryptionClient(this.awsCredentialsProvider, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(this.encryptionMaterials), this.clientConfiguration, this.cryptoConfiguration);
        if (StringUtils.isNotBlank((String)endpoint)) {
            this.amazonS3.setEndpoint(endpoint);
        }
        try {
            if (!this.amazonS3.doesBucketExist(this.bucketName)) {
                this.amazonS3.createBucket(this.bucketName, bucketRegion);
                this.amazonS3.setBucketAcl(this.bucketName, CannedAccessControlList.Private);
            }
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        File dir = File.createTempFile("nxbincache.", "", null);
        dir.delete();
        dir.mkdir();
        dir.deleteOnExit();
        long cacheSize = SizeUtils.parseSizeInBytes((String)cacheSizeStr);
        this.initializeCache(dir, cacheSize, this.newFileStorage());
        log.info((Object)("Using binary cache directory: " + dir.getPath() + " size: " + cacheSizeStr));
        this.createGarbageCollector();
    }

    protected static int getIntProperty(String key) {
        String s = Framework.getProperty((String)key);
        int value = -1;
        if (!StringUtils.isBlank((String)s)) {
            try {
                value = Integer.parseInt(s.trim());
            }
            catch (NumberFormatException e) {
                log.error((Object)("Cannot parse " + key + ": " + s));
            }
        }
        return value;
    }

    protected void createGarbageCollector() {
        this.garbageCollector = new S3BinaryGarbageCollector(this);
    }

    protected void removeBinary(String digest) {
        this.amazonS3.deleteObject(this.bucketName, digest);
    }

    protected static boolean isMissingKey(AmazonClientException e) {
        if (e instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)e;
            return ase.getStatusCode() == 404 || "NoSuchKey".equals(ase.getErrorCode()) || "Not Found".equals(e.getMessage());
        }
        return false;
    }

    public static boolean isMD5(String digest) {
        return MD5_RE.matcher(digest).matches();
    }

    protected FileStorage newFileStorage() {
        return new S3FileStorage();
    }

    public static class S3BinaryGarbageCollector
    implements BinaryGarbageCollector {
        protected final S3BinaryManager binaryManager;
        protected volatile long startTime;
        protected BinaryManagerStatus status;
        protected Set<String> marked;

        public S3BinaryGarbageCollector(S3BinaryManager binaryManager) {
            this.binaryManager = binaryManager;
        }

        public String getId() {
            return "s3:" + this.binaryManager.bucketName;
        }

        public BinaryManagerStatus getStatus() {
            return this.status;
        }

        public boolean isInProgress() {
            return this.startTime != 0L;
        }

        public void start() {
            if (this.startTime != 0L) {
                throw new RuntimeException("Already started");
            }
            this.startTime = System.currentTimeMillis();
            this.status = new BinaryManagerStatus();
            this.marked = new HashSet<String>();
            this.binaryManager.fileCache.clear();
        }

        public void mark(String digest) {
            this.marked.add(digest);
        }

        public void stop(boolean delete) {
            if (this.startTime == 0L) {
                throw new RuntimeException("Not started");
            }
            try {
                HashSet<String> unmarked = new HashSet<String>();
                ObjectListing list = null;
                do {
                    list = list == null ? this.binaryManager.amazonS3.listObjects(this.binaryManager.bucketName, this.binaryManager.bucketNamePrefix) : this.binaryManager.amazonS3.listNextBatchOfObjects(list);
                    for (S3ObjectSummary summary : list.getObjectSummaries()) {
                        String digest = summary.getKey();
                        if (!S3BinaryManager.isMD5(digest)) continue;
                        long length = summary.getSize();
                        if (this.marked.contains(digest)) {
                            ++this.status.numBinaries;
                            this.status.sizeBinaries += length;
                            continue;
                        }
                        ++this.status.numBinariesGC;
                        this.status.sizeBinariesGC += length;
                        unmarked.add(digest);
                        this.marked.remove(digest);
                    }
                } while (list.isTruncated());
                this.marked = null;
                if (delete) {
                    for (String digest : unmarked) {
                        this.binaryManager.removeBinary(digest);
                    }
                }
            }
            catch (AmazonClientException e) {
                throw new RuntimeException(e);
            }
            this.status.gcDuration = System.currentTimeMillis() - this.startTime;
            this.startTime = 0L;
        }
    }

    public class S3FileStorage
    implements FileStorage {
        public void storeFile(String digest, File file) throws IOException {
            String etag;
            long t0 = 0L;
            if (log.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
                log.debug((Object)("storing blob " + digest + " to S3"));
            }
            try {
                ObjectMetadata metadata = S3BinaryManager.this.amazonS3.getObjectMetadata(S3BinaryManager.this.bucketName, S3BinaryManager.this.bucketNamePrefix + digest);
                etag = metadata.getETag();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("blob " + digest + " is already in S3"));
                }
            }
            catch (AmazonClientException e) {
                if (!S3BinaryManager.isMissingKey(e)) {
                    throw new IOException(e);
                }
                try {
                    PutObjectResult result = S3BinaryManager.this.amazonS3.putObject(S3BinaryManager.this.bucketName, S3BinaryManager.this.bucketNamePrefix + digest, file);
                    etag = result.getETag();
                }
                catch (AmazonClientException ee) {
                    throw new IOException(ee);
                }
                finally {
                    if (log.isDebugEnabled()) {
                        long dtms = System.currentTimeMillis() - t0;
                        log.debug((Object)("stored blob " + digest + " to S3 in " + dtms + "ms"));
                    }
                }
            }
            if (!(S3BinaryManager.this.amazonS3 instanceof AmazonS3EncryptionClient) && !etag.equals(digest)) {
                throw new IOException("Invalid ETag in S3, ETag=" + etag + " digest=" + digest);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean fetchFile(String digest, File file) throws IOException {
            long t0 = 0L;
            if (log.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
                log.debug((Object)("fetching blob " + digest + " from S3"));
            }
            try {
                ObjectMetadata metadata = S3BinaryManager.this.amazonS3.getObject(new GetObjectRequest(S3BinaryManager.this.bucketName, S3BinaryManager.this.bucketNamePrefix + digest), file);
                String etag = metadata.getETag();
                if (!(S3BinaryManager.this.amazonS3 instanceof AmazonS3EncryptionClient) && !etag.equals(digest)) {
                    log.error((Object)("Invalid ETag in S3, ETag=" + etag + " digest=" + digest));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (AmazonClientException e) {
                if (!S3BinaryManager.isMissingKey(e)) {
                    throw new IOException(e);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (log.isDebugEnabled()) {
                    long dtms = System.currentTimeMillis() - t0;
                    log.debug((Object)("fetched blob " + digest + " from S3 in " + dtms + "ms"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long fetchLength(String digest) throws IOException {
            long t0 = 0L;
            if (log.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
                log.debug((Object)("fetching blob length " + digest + " from S3"));
            }
            try {
                ObjectMetadata metadata = S3BinaryManager.this.amazonS3.getObjectMetadata(S3BinaryManager.this.bucketName, S3BinaryManager.this.bucketNamePrefix + digest);
                String etag = metadata.getETag();
                if (!(S3BinaryManager.this.amazonS3 instanceof AmazonS3EncryptionClient) && !etag.equals(digest)) {
                    log.error((Object)("Invalid ETag in S3, ETag=" + etag + " digest=" + digest));
                    Long l = null;
                    return l;
                }
                Long l = metadata.getContentLength();
                return l;
            }
            catch (AmazonClientException e) {
                if (!S3BinaryManager.isMissingKey(e)) {
                    throw new IOException(e);
                }
                Long l = null;
                return l;
            }
            finally {
                if (log.isDebugEnabled()) {
                    long dtms = System.currentTimeMillis() - t0;
                    log.debug((Object)("fetched blob length " + digest + " from S3 in " + dtms + "ms"));
                }
            }
        }
    }
}

