/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.proxy;

import edu.yale.its.tp.cas.util.SecureURL;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProxyTicketReceptor
extends HttpServlet {
    private static final String PGT_IOU_PARAM = "pgtIou";
    private static final String PGT_ID_PARAM = "pgtId";
    private static Map pgt;
    private static String casProxyUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Class<ProxyTicketReceptor> clazz = ProxyTicketReceptor.class;
        synchronized (ProxyTicketReceptor.class) {
            ServletContext app;
            if (pgt == null) {
                pgt = new HashMap();
            }
            if (casProxyUrl == null && (casProxyUrl = (app = config.getServletContext()).getInitParameter("edu.yale.its.tp.cas.proxyUrl")) == null) {
                throw new ServletException("need edu.yale.its.tp.cas.proxyUrl");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pgtId = request.getParameter(PGT_ID_PARAM);
        String pgtIou = request.getParameter(PGT_IOU_PARAM);
        if (pgtId != null && pgtIou != null) {
            Map map = pgt;
            synchronized (map) {
                pgt.put(pgtIou, pgtId);
            }
        }
        PrintWriter out = response.getWriter();
        out.println("<casClient:proxySuccess xmlns:casClient=\"http://www.yale.edu/tp/casClient\"/>");
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProxyTicket(String pgtIou, String target) throws IOException {
        Class<ProxyTicketReceptor> clazz = ProxyTicketReceptor.class;
        synchronized (ProxyTicketReceptor.class) {
            if (casProxyUrl == null || pgt == null) {
                throw new IllegalStateException("getProxyTicket() only works after servlet has been initialized");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            String pgtId = null;
            Map map = pgt;
            synchronized (map) {
                pgtId = (String)pgt.get(pgtIou);
            }
            if (pgtId == null) {
                return null;
            }
            String url = casProxyUrl + "?pgt=" + pgtId + "&targetService=" + target;
            String response = SecureURL.retrieve(url);
            if (response.indexOf("<cas:proxySuccess>") != -1 && response.indexOf("<cas:proxyTicket>") != -1) {
                int startIndex = response.indexOf("<cas:proxyTicket>") + "<cas:proxyTicket>".length();
                int endIndex = response.indexOf("</cas:proxyTicket>");
                return response.substring(startIndex, endIndex);
            }
            return null;
        }
    }
}

