#nuxeo.io Manager
---

### nuxeo.io Manager Front Application

In case you are trying your cluster locally, and do not have any DNS setuped. You can edit your `/etc/hosts` file or configuring [Dnsmasq](http://www.thekelleys.org.uk/dnsmasq/doc.html).

- Go to `http://domain manager.my.cloud.io.dev/nuxeo/nuxeo.io/` to get access to the manager dashboard

### Running the manager locally

Asumming you have a cluster already running:

- Build and install the nuxeo.io MP in a local Nuxeo
- Configure the VM ports forwarding (in Virtual Box) to forward the etcd port (4001).
- Configure the etcd endpoint in `nuxeo.conf`:
  - `org.nuxeo.io.etcd.endpoint=http://localhost:4001`
- Configure other properties (if needed) in `nuxeo.conf` as you cannot rely on the manager unit:
  - org.nuxeo.connect.url
  - io.oauth.consumer.key
  - io.oauth.consumer.secret
  - org.nuxeo.io.defaultDomainSuffix

You need to have `fleetctl` available in your `PATH` with the same version as the one in your cluster. The manager relies on it to submit / start / stop environments.

To know the version, login into your cluster and run:

    fleetctl --version

Download the right version [here](https://github.com/coreos/fleet/releases).

You can then use http://localhost:8080/nuxeo to manage environments.

## Creating nuxeo.io containers


- From your browser, go to `http://domain manager.my.cloud.io.dev/nuxeo/`
    - Create a "Client"

    ![](./README.img/nuxeoioDM1.png)

    ![](./README.img/nuxeoioDM2.png)

    - Make sure you have all these documents created

    ![](./README.img/nuxeoioDM3.png)

- From your browser, go to `http://domain manager.my.cloud.io.dev/nuxeo/nuxeo.io`
  - Click on Environment

  ![](./README.img/nuxeoioSC1.png)

  - Create an environment (for instance `nuxeo-demo`)

  ![](./README.img/nuxeoioSC2.png)

  - Click on Start button

  - Before clicking on the new Nuxeo cloud `Domain` instance link, you have to configure locally your `hosts configuration`:
      - Open your Terminal and edit /etc/hosts file
      - Add a new entry on a new line: `127.0.0.1 nuxeo-demo-vlad.trial.nuxeo.io`

  - Open your browser @ `http://nuxeo-demo-vlad.trial.nuxeo.io.dev:7777` or click on the `Domain` instance link

  ![](./README.img/nuxeoioSC3.png)

- Miscellaneous
  - You can click on Stop button to suspend your instance
  - Clicking the Delete button will remove all instance data


Report & Contribute
-------------------

We are glad to welcome new developers on this initiative, and even simple usage feedback is great.
- Ask your questions on [Nuxeo Answers](http://answers.nuxeo.com)
- Report issues on this github repository (see [issues link](http://github.com/nuxeo/nuxeo.io/issues) on the right)
- Contribute: Send pull requests!
