# Semantic [![Build Status](https://travis-ci.org/Semantic-Org/Semantic-UI.svg?branch=master)](https://travis-ci.org/Semantic-Org/Semantic-UI?branch=master)
Semantic is a UI Component library implemented using a set of specifications designed around natural language.

Semantic UI is under constant development, so **be sure to check out our [release notes](https://github.com/Semantic-Org/Semantic-UI/blob/master/RELEASE%20NOTES.md) for recent changes**.

> Community contributed plugins and ports for Wordpress, Angular, Dart, Knockout, Rails, and more can be found on the [Integration page](https://github.com/Semantic-Org/Semantic-UI/wiki/Integration).

### Project Status

**Semantic is being reworked for a ``1.0`` release for Spring.**

Although the pre-release branch ``0.x.x`` is actively being maintained, most important features like better theming support, and new components will land in ``1.0``.

Beta documentation will be available soon for testers and early adopters.

## Translations

##### Right-to-Left (RTL Version)

Special RTL versions are maintained with the Arabic translation of Semantic.

* سيمانتك يو آي - الإصدار العربي - [GitHub](https://github.com/Semantic-Org/Semantic-UI-ar) - [Website](http://semantic-ui.me/)

##### Additional Translations
* 中文翻译 Semantic UI - [GitHub](https://github.com/Semantic-Org/Semantic-UI-zh) - [Website](http://zh.semantic-ui.com/)

* Tradução em Português - [GitHub](https://github.com/Semantic-Org/Semantic-UI-pt-br)

We need people who can contribute to translations of Semantic UI's documentation.

Please [reach out by e-mail](mailto:jack@semantic-ui.com) if you can help.

## Getting Started

The Semantic library describes many UI elements. In most instances it might be best to build a custom build with only the elements you need.

To download the entire library

    git clone git@github.com:Semantic-Org/Semantic-UI.git

If you prefer to download the whole kit as a zip, it is so conveniently packaged.

    http://semantic-ui.com/build/semantic.zip

Semantic is also available from CDN

* [Hosted on CloudFlare CDN](http://cdnjs.com/libraries/semantic-ui/)
* [Hosted on BootCDN](http://open.bootcss.com/semantic-ui/) (Chinese)

## Learn More

* [Introduction to Semantic](http://www.semantic-ui.com/introduction.html)
* [Semantic Modules](http://www.semantic-ui.com/module.html)
* [Contributing to Semantic](http://semantic-ui.com/project/contributing.html)
* [Running Docs/Server Locally](http://semantic-ui.com/project/development)

If you want to keep track of development, please [join our google group](https://groups.google.com/forum/?hl=en#!forum/semantic-ui)


### Bugs and Issues

> Semantic UI is production ready, but is "pre-release" until build and theming tools are available, and documentation is complete for all components.

Please [share any issues](https://github.com/Semantic-Org/Semantic-UI/issues?state=open) you may have. We need your help to get all the kinks out.

If you are reporting a bug *you must create a test-case*. You can [fork this jsfiddle](http://jsfiddle.net/Vbr9d/42/) to get you started.

If you need help, come hang out in `#semantic-ui` on *irc.freenode.net*.  Click here to use [webchat](http://webchat.freenode.net/?randomnick=1&channels=%23semantic-ui&prompt=1&uio=OT10cnVlJjExPTEyMwb9).

### Browser Support

* Last 2 Versions FF, Chrome, IE (aka 10+)
* Safari 6
* Firefox 12
* IE 9+ (Browser prefix only)
* Android 3
* Blackberry 10

### Reaching Out

If you'd like to start a conversation about Semantic feel free to reach out by e-mail [jack@semantic-ui.com](mailto:jack@semantic-ui.com)


### Roadmap
* [Features Missing for 1.0](https://github.com/Semantic-Org/Semantic-UI/issues?direction=desc&milestone=1&page=1&sort=updated&state=open)
* [Planned Updates for 1.X](https://github.com/Semantic-Org/Semantic-UI/issues?direction=desc&milestone=2&page=1&sort=updated&state=open)
* [Additional Components Scoped for 2.0](https://github.com/Semantic-Org/Semantic-UI/issues?direction=desc&labels=&milestone=3&page=1&sort=updated&state=open)


[![Bitdeli Badge](https://d2weczhvl823v0.cloudfront.net/Semantic-Org/semantic-ui/trend.png)](https://bitdeli.com/free "Bitdeli Badge")

