/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */

package org.nuxeo.io;

/**
 * Constants class.
 *
 * @since 1.0
 */
public final class Constants {

    private Constants() {
        // Constants class
    }

    public static final String DEFAULT_DOMAIN_SUFFIX_KEY = "org.nuxeo.io.defaultDomainSuffix";

    public static final String BLOCK_DOMAIN_SUFFIX_KEY = "org.nuxeo.io.blockDomainSuffix";

    public static final String CONNECT_URL_KEY = "org.nuxeo.connect.url";

    /** Core Types */

    public static final String NUXEO_IO_FACET = "NuxeoIO";

    public static final String IO_ROOT_DOCUMENT_TYPE = "ioRoot";

    public static final String IO_CLIENTS_DOCUMENT_TYPE = "ioClients";

    public static final String IO_CLIENT_DOCUMENT_TYPE = "ioClient";

    public static final String IO_CLIENT_SCHEMA = "ioclient";

    public static final String IO_CLIENT_LIMIT_PROPERTY = IO_CLIENT_SCHEMA
            + ":envLimit";

    public static final String IO_APPLICATIONS_DOCUMENT_TYPE = "ioApplications";

    public static final String IO_APPLICATION_DOCUMENT_TYPE = "ioApplication";

    public static final String IO_ENVIRONMENTS_DOCUMENT_TYPE = "ioEnvironments";

    public static final String IO_ENVIRONMENT_DOCUMENT_TYPE = "ioEnvironment";

    public static final String IO_ENVIRONMENT_SCHEMA = "ioenvironment";

    public static final String IO_ENVIRONMENT_DESCRIPTION_PROPERTY = "dc:description";

    public static final String IO_ENVIRONMENT_DOMAIN_PROPERTY = IO_ENVIRONMENT_SCHEMA
            + ":domain";

    public static final String IO_ENVIRONMENT_TYPE_PROPERTY = IO_ENVIRONMENT_SCHEMA
            + ":type";

    public static final String IO_ENVIRONMENT_APPLICATION_PROPERTY = IO_ENVIRONMENT_SCHEMA
            + ":application";

    public static final String IO_ENVIRONMENT_APPLICATION_ID_PROPERTY = IO_ENVIRONMENT_SCHEMA
            + ":applicationId";

    public static final String IO_ENVIRONMENT_TECH_ID_PROPERTY = IO_ENVIRONMENT_SCHEMA
            + ":techId";

    public static final String IO_APPLICATION_SCHEMA = "ioapplication";

    public static final String IO_APPLICATION_DESCRIPTION_PROPERTY = "dc:description";

    public static final String IO_APPLICATION_STUDIO_PROJECT_PROPERTY = IO_APPLICATION_SCHEMA
            + ":studioProject";

    public static final String IO_APPLICATION_STUDIO_PROJECT_NAME_PROPERTY = IO_APPLICATION_STUDIO_PROJECT_PROPERTY
            + "/symbolicName";

    public static final String IO_APPLICATION_STUDIO_PROJECT_TAG_PROPERTY = IO_APPLICATION_STUDIO_PROJECT_PROPERTY
            + "/tag";

    public static final String IO_APPLICATION_STUDIO_PROJECT_CONNECT_CLIENT_PROPERTY = IO_APPLICATION_STUDIO_PROJECT_PROPERTY
            + "/connectClientUid";

    /** REST API */

    public static final String NUXEO_IO_ROOT_PATH = "/io";

    public static final String NUXEO_IO_CLIENTS_PATH = NUXEO_IO_ROOT_PATH
            + "/clients";

    public static final String NUXEO_IO_ENVIRONMENTS_PATH = NUXEO_IO_ROOT_PATH
            + "/clients/%s/environments";

    public static final String NUXEO_IO_APPLICATIONS_PATH = NUXEO_IO_ROOT_PATH
            + "/clients/%s/applications";

    public static final String DOCKER_CONTAINER_NAME = "nuxeoio/iocontainer";

    public static final String DOCKER_REGISTRY_RESOURCE = "https://quay.io/v1/repositories/%s/tags/%s";

}
