/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */
package org.nuxeo.io;

import static org.jboss.seam.ScopeType.SESSION;
import static org.nuxeo.io.action.NuxeoIOHelper.NUXEO_IO_DASHBOARD;

import java.io.IOException;

import javax.faces.context.FacesContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webapp.helpers.StartupHelper;
import org.nuxeo.io.action.NuxeoIOHelper;

@Name("startupHelper")
@Scope(SESSION)
public class NuxeoIOStartupHelper extends StartupHelper {

    private static final long serialVersionUID = 3248232383219879845L;

    private static final Log log = LogFactory.getLog(NuxeoIOStartupHelper.class);

    @Override
    @Begin(id = "#{conversationIdGenerator.nextMainConversationId}", join = true)
    public String initDomainAndFindStartupPage(String domainTitle, String viewId) {
        String result = super.initDomainAndFindStartupPage(domainTitle, viewId);
        if (((NuxeoPrincipal) documentManager.getPrincipal()).isAdministrator()) {
            return result;
        } else {
            redirect(NuxeoIOHelper.linkToIoDashboard());
            return null;
        }
    }

    public void redirect(String url) {
        HttpServletResponse response = getHttpServletResponse();
        try {
            response.resetBuffer();
            response.sendRedirect(url);
            response.flushBuffer();

            FacesContext.getCurrentInstance().responseComplete();
        } catch (IOException e) {
            log.warn(e);
            log.debug(e, e);
        }
    }

    public HttpServletResponse getHttpServletResponse() {
        ServletResponse response = null;
        final FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            response = (ServletResponse) facesContext.getExternalContext().getResponse();
        }

        if (response != null && response instanceof HttpServletResponse) {
            return (HttpServletResponse) response;
        }
        return null;
    }
}
