package org.nuxeo.io.connect;

import java.security.Principal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.api.Framework;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;

/**
 * @author <a href="mailto:ak@nuxeo.com">Arnaud Kervern</a>
 * @since 5.9.4
 */
public class IoConnectClient {

    public static String TARGET_PLATFORM_ENDPOINT = ConnectUrlConfig.getBaseUrl() + "studio/projects/%s/targetplatform";

    private static final Log log = LogFactory.getLog(IoConnectClient.class);

    private IoConnectClient() {
    }

    public static Client instance() {
        Client c = Client.create();
        c.setConnectTimeout(20000);
        return c;
    }

    public static WebResource resource(String resource) {
        Client c = instance();

        WebResource r = c.resource(resource);

        try {
            try (CoreSession session = CoreInstance.openCoreSession(Framework.getLocalService(
                    RepositoryManager.class).getDefaultRepositoryName())) {
                Principal principal = session.getPrincipal();
                // Use originating principal if exists.

                String principalName = (principal instanceof NuxeoPrincipal) ? ((NuxeoPrincipal) principal).getActingUser()
                        : principal.getName();
                r.addFilter(new OauthAuthFilter(principalName));
            }
        } catch (ClientException e) {
            log.error(e, e);
        }

        return r;
    }
}
