/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo
 */

package org.nuxeo.io.operation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.io.service.IoService;

/**
 * @author <a href="mailto:ak@nuxeo.com">Arnaud Kervern</a>
 * @since 0.4
 */
@Operation(id = CheckContainerAvailability.ID, category = "Io", label = "Check a container version availability", description = "Requesting our container registry to check if the expected is existing.")
public class CheckContainerAvailability {
    public static final String ID = "Io.ContainerAvailability";

    @Param(name = "targetPlatform")
    protected String targetPlatform;

    @Context
    protected IoService ioService;

    /**
     * Operation method is used as a REST resource, only the response code is interesting.
     */
    @OperationMethod
    public Object checkContainer() {
        if (ioService.checkPlatformAvailability(targetPlatform)) {
            throw new ClientException("Unknown target platform: " + targetPlatform);
        }
        return null;
    }
}
