/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */

package org.nuxeo.io.operation;

import static org.nuxeo.io.Constants.IO_CLIENT_DOCUMENT_TYPE;

import java.util.ArrayList;
import java.util.List;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.io.adapter.IoClient;
import org.nuxeo.io.adapter.IoUser;
import org.nuxeo.io.service.IoService;

/**
 * @since 1.0
 */
@Operation(id = GetIoUser.ID, category = "Io", label = "Get the current logged in user information", description = "Get the current logged in user information. Return the list of associated clients")
public class GetIoUser {

    public static final String ID = "Io.GetUser";

    @Context
    protected CoreSession session;

    @Context
    protected IoService ioService;

    @OperationMethod
    public IoUser run() throws Exception {
        try {
            NuxeoPrincipal currentUser = (NuxeoPrincipal) session.getPrincipal();
            List<DocumentModel> clients = session.query(String.format(
                    "SELECT * FROM Document WHERE ecm:primaryType = '%s' AND ecm:currentLifeCycleState != 'deleted'",
                    IO_CLIENT_DOCUMENT_TYPE));
            return new IoUser(currentUser, toIoClients(clients),
                    ioService.getAvailableConnectProjects());
        } catch (ClientException e) {
            throw WebException.wrap(e);
        }
    }

    protected static List<IoClient> toIoClients(List<DocumentModel> clients) {
        List<IoClient> ioClients = new ArrayList<>();
        for (DocumentModel client : clients) {
            ioClients.add(client.getAdapter(IoClient.class));
        }
        return ioClients;
    }
}
