/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */

package org.nuxeo.io.service;

import java.util.Arrays;
import java.util.List;

/**
 * @since 1.0
 */
public class EnvironmentStatusComputer {

    public static final String STARTING_STATUS = "starting";

    public static final String STARTED_STATUS = "started";

    public static final String STOPPING_STATUS = "stopping";

    public static final String STOPPED_STATUS = "stopped";

    public static final String PASSIVATED_STATUS = "passivated";

    public static final String ERROR_STATUS = "error";

    public static final String NA_STATUS = "n/a";

    public static final List<String> EXPECTED_STATUSES = Arrays.asList(
            STARTED_STATUS, STOPPED_STATUS, PASSIVATED_STATUS);

    public static final List<String> CURRENT_STATUSES = Arrays.asList(
            STARTING_STATUS, STARTED_STATUS, STOPPING_STATUS, STOPPED_STATUS);

    protected final String expectedStatus;

    protected final String currentStatus;

    protected final String alive;

    public EnvironmentStatusComputer(String expectedStatus,
            String currentStatus, String alive) {
        this.expectedStatus = expectedStatus;
        this.currentStatus = currentStatus;
        this.alive = alive;
    }

    public String computeStatus() {
        String status;
        if (!EXPECTED_STATUSES.contains(expectedStatus)
                || !CURRENT_STATUSES.contains(currentStatus)) {
            status = NA_STATUS;
        } else {
            switch (currentStatus) {
            case STOPPED_STATUS:
                if (!expectedStatus.equals(PASSIVATED_STATUS)) {
                    status = expectedStatus.equals(STOPPED_STATUS) ?
                            STOPPED_STATUS : ERROR_STATUS;
                } else {
                    status = PASSIVATED_STATUS;
                }
                break;
            case STARTING_STATUS:
                status = expectedStatus.equals(STARTED_STATUS) ? STARTING_STATUS
                        : ERROR_STATUS;
                break;
            case STARTED_STATUS:
                if (alive != null) {
                    status = expectedStatus.equals(STARTED_STATUS) ? STARTED_STATUS
                            : ERROR_STATUS;
                } else {
                    status = ERROR_STATUS;
                }
                break;
            case STOPPING_STATUS:
                status = expectedStatus.equals(STOPPED_STATUS) ? STOPPING_STATUS
                        : ERROR_STATUS;
                break;
            default:
                status = NA_STATUS;
            }
        }
        return status;
    }
}
