/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */

package org.nuxeo.io;

import static org.nuxeo.io.Constants.IO_ROOT_DOCUMENT_TYPE;
import static org.nuxeo.io.Constants.NUXEO_IO_ROOT_PATH;

import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandler;

/**
 * Creates the nuxeo.io Root document if not present.
 *
 * @since 1.0
 */
public class IoHandler implements PostContentCreationHandler {

    public static final String DC_TITLE = "dc:title";

    @Override
    public void execute(CoreSession session) {
        try {
            DocumentRef docRef = new PathRef("/io");
            if (!session.exists(docRef)) {
                Path path = new Path(NUXEO_IO_ROOT_PATH);
                String parentPath = path.removeLastSegments(1).toString();
                String name = path.lastSegment();

                DocumentModel doc = session.createDocumentModel(parentPath,
                        name, IO_ROOT_DOCUMENT_TYPE);
                doc.setPropertyValue(DC_TITLE, "nuxeo.io");
                session.createDocument(doc);
            }
        } catch (ClientException e) {
            throw new ClientRuntimeException(e);
        }
    }
}
