package org.nuxeo.io.connect;

import javax.ws.rs.core.MultivaluedMap;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.registration.RegistrationHelper;
import org.nuxeo.runtime.api.Framework;

import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;

/**
 * @author <a href="mailto:ak@nuxeo.com">Arnaud Kervern</a>
 * @since 5.9.4
 */
public class InstanceRegistrator {

    private static final Log log = LogFactory.getLog(InstanceRegistrator.class);

    protected String projectId;

    protected String description;

    protected NuxeoClientInstanceType type;

    public InstanceRegistrator(String projectId, String description,
            NuxeoClientInstanceType type) {
        this.projectId = projectId;
        this.description = description;
        this.type = type;
    }

    public LogicalInstanceIdentifier getCLIDs() {
        if (Framework.isTestModeSet()) {
            return null;
        }

        WebResource r = IoConnectClient.resource(registrationResource());

        MultivaluedMap<String, String> params = new MultivaluedMapImpl();
        params.add("projectId", projectId);
        params.add("description", description);
        params.add("type", type.getValue());
        params.add("CTID", null);

        String CLIDs = r.post(String.class, params);

        try {
            return new LogicalInstanceIdentifier(CLIDs, description);
        } catch (LogicalInstanceIdentifier.InvalidCLID invalidCLID) {
            log.warn(invalidCLID, invalidCLID);
            return null;
        }
    }

    protected String registrationResource() {
        return ConnectUrlConfig.getRegistrationBaseUrl()
                + RegistrationHelper.POST_REGISTER_SUFFIX;
    }
}
