/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo
 */

package org.nuxeo.io.service;

import org.nuxeo.io.adapter.IoEnvironment;

/**
 * @author <a href="mailto:ak@nuxeo.com">Arnaud Kervern</a>
 * @since 0.6
 */
public interface IoEtcdService {
    public String getValue(String key);

    public void setValue(String key, String value);

    public void setValue(String key, String value, int ttl);

    public void createEnvironment(IoEnvironment environment);

    public void deleteDomain(IoEnvironment environment);

    public void setDomain(IoEnvironment environment);

    public String getClid(IoEnvironment environment);

    public String getEnvironmentStatus(IoEnvironment environment);
}
