/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */
package org.nuxeo.io.action;

import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.runtime.api.Framework;

import static org.jboss.seam.ScopeType.EVENT;

@Name("ioHelper")
@Scope(EVENT)
public class NuxeoIOHelper {

    public static final String NUXEO_URL_KEY = "nuxeo.url";

    public static final String NUXEO_IO_DASHBOARD = "/nuxeo.io/";

    public String linkToIoDashboard() {
        String baseUrl = Framework.getProperty(NUXEO_URL_KEY);
        return baseUrl + NUXEO_IO_DASHBOARD;
    }

}
