/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */

package org.nuxeo.io.adapter;

import java.io.Serializable;

import org.nuxeo.ecm.automation.core.operations.business.adapter.BusinessAdapter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;

/**
 * @since 1.0
 */
public abstract class AbstractAdapter extends BusinessAdapter {

    protected AbstractAdapter() {
        super();
    }

    protected AbstractAdapter(DocumentModel doc) {
        super(doc);
    }

    protected <T> T getPropertyValue(String xpath, Class<T> clazz) {
        try {
            return clazz.cast(doc.getPropertyValue(xpath));
        } catch (ClientException e) {
            throw new ClientRuntimeException(e);
        }
    }

    protected void setPropertyValue(String xpath, Serializable value) {
        try {
            doc.setPropertyValue(xpath, value);
        } catch (ClientException e) {
            throw new ClientRuntimeException(e);
        }
    }

}
