/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */
package org.nuxeo.io.adapter;

import static org.nuxeo.io.Constants.IO_APPLICATION_DESCRIPTION_PROPERTY;
import static org.nuxeo.io.Constants.IO_APPLICATION_STUDIO_PROJECT_NAME_PROPERTY;
import static org.nuxeo.io.Constants.IO_APPLICATION_STUDIO_PROJECT_TAG_PROPERTY;
import static org.nuxeo.io.Constants.IO_ENVIRONMENT_DESCRIPTION_PROPERTY;

import java.util.Calendar;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;

/**
 * Adapter for ioApplication document type
 *
 * @since 1.0
 */
public class IoApplication extends AbstractAdapter {

    public IoApplication() {
        super();
    }

    public IoApplication(DocumentModel doc) {
        super(doc);
    }

    public String getName() {
        try {
            return doc.getTitle();
        } catch (ClientException e) {
            throw new ClientRuntimeException(e);
        }
    }

    public void setName(String name) {
        setPropertyValue("dc:title", name);
    }

    public String getPath() {
        return doc.getPathAsString();
    }

    public Calendar getCreationDate() {
        return getPropertyValue("dc:created", Calendar.class);
    }

    public Calendar getModificationDate() {
        return getPropertyValue("dc:modified", Calendar.class);
    }

    public String getLastContributor() {
        return getPropertyValue("dc:lastContributor", String.class);
    }

    public String getVersion() {
        return doc.getVersionLabel();
    }

    public String getDescription() {
        return getPropertyValue(IO_APPLICATION_DESCRIPTION_PROPERTY,
                String.class);
    }

    public void setDescription(String description) {
        setPropertyValue(IO_ENVIRONMENT_DESCRIPTION_PROPERTY, description);
    }

    public String getStudioProjectName() {
        return getPropertyValue(IO_APPLICATION_STUDIO_PROJECT_NAME_PROPERTY,
                String.class);
    }

    public void setStudioProjectName(String studioProjectName) {
        setPropertyValue(IO_APPLICATION_STUDIO_PROJECT_NAME_PROPERTY,
                studioProjectName);
    }

    public String getStudioProjectTag() {
        return getPropertyValue(IO_APPLICATION_STUDIO_PROJECT_TAG_PROPERTY,
                String.class);
    }

    public void setStudioProjectTag(String studioProjectTag) {
        setPropertyValue(IO_APPLICATION_STUDIO_PROJECT_TAG_PROPERTY,
                studioProjectTag);
    }

}
