/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */

package org.nuxeo.io.adapter;

import static org.nuxeo.io.Constants.IO_CLIENT_LIMIT_PROPERTY;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;

/**
 * @since 1.0
 */
public class IoClient {

    protected DocumentModel doc;

    public IoClient(DocumentModel doc) {
        this.doc = doc;
    }

    public String getId() {
        return doc.getId();
    }

    public String getName() {
        return doc.getName();
    }

    public String getPath() {
        return doc.getPathAsString();
    }

    public String getTitle() {
        try {
            return doc.getTitle();
        } catch (ClientException e) {
            return "";
        }
    }

    public long getLimit() {
        try {
            return (Long) doc.getPropertyValue(IO_CLIENT_LIMIT_PROPERTY);
        } catch (ClientException e) {
            return 0;
        }
    }

    @JsonIgnore
    public DocumentModel getDocument() throws ClientException {
        return doc;
    }
}
