/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */
package org.nuxeo.io.adapter;

import static org.nuxeo.io.Constants.IO_ENVIRONMENT_APPLICATION_PROPERTY;
import static org.nuxeo.io.Constants.IO_ENVIRONMENT_DESCRIPTION_PROPERTY;
import static org.nuxeo.io.Constants.IO_ENVIRONMENT_DOMAIN_PROPERTY;
import static org.nuxeo.io.Constants.IO_ENVIRONMENT_TECH_ID_PROPERTY;
import static org.nuxeo.io.Constants.IO_ENVIRONMENT_TYPE_PROPERTY;

import java.util.Calendar;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;

/**
 * Adapter for ioEnvironment document type
 *
 * @since 1.0
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class IoEnvironment extends AbstractAdapter {

    public IoEnvironment() {
        super();
    }

    public IoEnvironment(DocumentModel doc) {
        super(doc);
    }

    public String getName() {
        try {
            return doc.getTitle();
        } catch (ClientException e) {
            throw new ClientRuntimeException(e);
        }
    }

    public void setName(String name) {
        setPropertyValue("dc:title", name);
    }

    public String getPath() {
        return doc.getPathAsString();
    }

    public Calendar getCreationDate() {
        return getPropertyValue("dc:created", Calendar.class);
    }

    public Calendar getModificationDate() {
        return getPropertyValue("dc:modified", Calendar.class);
    }

    public String getLastContributor() {
        return getPropertyValue("dc:lastContributor", String.class);
    }

    public String getVersion() {
        return doc.getVersionLabel();
    }

    public String getDescription() {
        return getPropertyValue(IO_ENVIRONMENT_DESCRIPTION_PROPERTY,
                String.class);
    }

    public void setDescription(String description) {
        setPropertyValue(IO_ENVIRONMENT_DESCRIPTION_PROPERTY, description);
    }

    public String getTechId() {
        return getPropertyValue(IO_ENVIRONMENT_TECH_ID_PROPERTY, String.class);
    }

    public String getEnvironmentType() {
        return getPropertyValue(IO_ENVIRONMENT_TYPE_PROPERTY, String.class);
    }

    public void setEnvironmentType(String type) {
        setPropertyValue(IO_ENVIRONMENT_TYPE_PROPERTY, type);
    }

    public String getDomain() {
        return getPropertyValue(IO_ENVIRONMENT_DOMAIN_PROPERTY, String.class);
    }

    public void setDomain(String domain) {
        setPropertyValue(IO_ENVIRONMENT_DOMAIN_PROPERTY, domain);
    }

    public String getApplication() {
        return getPropertyValue(IO_ENVIRONMENT_APPLICATION_PROPERTY,
                String.class);
    }

    public void setApplication(String application) {
        setPropertyValue(IO_ENVIRONMENT_APPLICATION_PROPERTY, application);
    }

}
