/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */

package org.nuxeo.io.operation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.io.adapter.IoEnvironment;
import org.nuxeo.io.service.IoService;

/**
 * @since 1.0
 */
@Operation(id = StopEnvironment.ID, category = "Environment", label = "Start the given Environment", description = "Start the Environment using IoService.")
public class StopEnvironment {

    public static final String ID = "Environment.Stop";

    @Context
    protected IoService ioService;

    @OperationMethod
    public void run(DocumentModel doc) throws Exception {
        ioService.stopEnvironment(doc.getAdapter(IoEnvironment.class));
    }
}
