/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     nuxeo.io Team
 */

package org.nuxeo.io.service;

import java.util.List;

import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.io.adapter.IoEnvironment;
import org.nuxeo.io.adapter.IoEnvironmentStatus;

/**
 * Service used to manage environments on the cloud.
 *
 * @since 1.0
 */
public interface IoService {

    void createEnvironment(IoEnvironment environment);

    void startEnvironment(IoEnvironment environment);

    void stopEnvironment(IoEnvironment environment);

    void updateEnvironment(IoEnvironment oldEnvironment,
            IoEnvironment newEnvironment);

    void deleteEnvironment(IoEnvironment environment);

    IoEnvironmentStatus getEnvironmentStatus(IoEnvironment environment);

    List<ConnectProject> getAvailableConnectProjects();
}
